/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.probe;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.ImplementationFilter;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.tracer.probe.Probe;
import com.android.sched.util.log.tracer.probe.TimeNanosProbe;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

@ImplementationName(iface=Probe.class, name="thread-contention-duration", filter=Filter.class)
public class ThreadContentionDurationProbe
extends TimeNanosProbe {
    @Nonnull
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public ThreadContentionDurationProbe() {
        super("Thread contention duration", 5);
        this.threadMXBean.setThreadContentionMonitoringEnabled(true);
    }

    @Override
    @Nonnegative
    public long read() {
        return this.threadMXBean.getThreadInfo(Thread.currentThread().getId()).getBlockedTime() * 1000L * 1000L;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    static class Filter
    implements ImplementationFilter {
        Filter() {
        }

        @Override
        public boolean isValid() {
            try {
                ThreadMXBean threadManager = ManagementFactory.getThreadMXBean();
                return threadManager.isThreadContentionMonitoringSupported();
            }
            catch (Throwable e) {
                return false;
            }
        }
    }
}

