/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.probe;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.ImplementationFilter;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.tracer.probe.Probe;
import com.android.sched.util.log.tracer.probe.TimeNanosProbe;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;

@ImplementationName(iface=Probe.class, name="jit-duration", filter=Filter.class)
public class JitDurationProbe
extends TimeNanosProbe {
    @Nonnull
    private final CompilationMXBean compilerMXBean = ManagementFactory.getCompilationMXBean();

    public JitDurationProbe() {
        super("JIT compiler duration", 12);
    }

    @Override
    @Nonnegative
    public long read() {
        return this.compilerMXBean.getTotalCompilationTime() * 1000L * 1000L;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    static class Filter
    implements ImplementationFilter {
        Filter() {
        }

        @Override
        public boolean isValid() {
            try {
                CompilationMXBean compilerMXBean = ManagementFactory.getCompilationMXBean();
                return compilerMXBean.isCompilationTimeMonitoringSupported();
            }
            catch (Throwable e) {
                return false;
            }
        }
    }
}

