/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.probe;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.tracer.probe.Probe;
import com.android.sched.util.log.tracer.probe.TimeNanosProbe;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

@ImplementationName(iface=Probe.class, name="gc-duration")
public class GcDurationProbe
extends TimeNanosProbe {
    @Nonnull
    private final List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();

    public GcDurationProbe() {
        super("Garbage Collector duration", 10);
    }

    @Override
    @Nonnegative
    public long read() {
        long count = 0L;
        for (GarbageCollectorMXBean gc : this.gcs) {
            count += gc.getCollectionTime();
        }
        return count * 1000L * 1000L;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

