/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.tracer.probe;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.log.tracer.probe.Probe;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

@ImplementationName(iface=Probe.class, name="gc-count")
public class GcCountProbe
extends Probe {
    @Nonnull
    private final List<GarbageCollectorMXBean> gcs = ManagementFactory.getGarbageCollectorMXBeans();

    public GcCountProbe() {
        super("Garbage Collector Count", 10);
    }

    @Override
    @Nonnegative
    public long read() {
        long count = 0L;
        for (GarbageCollectorMXBean gc : this.gcs) {
            count += gc.getCollectionCount();
        }
        return count;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    @Nonnull
    public String formatValue(long value) {
        return Long.valueOf(value).toString();
    }
}

