/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.stats;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.HasDescription;
import com.android.sched.util.config.ReflectFactory;
import com.android.sched.util.log.stats.Statistic;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatisticId<T extends Statistic>
implements HasDescription {
    @Nonnull
    private static Map<Class<? extends Statistic>, Statistic> dummies = new ConcurrentHashMap<Class<? extends Statistic>, Statistic>();
    @Nonnull
    private static Map<Class<? extends Statistic>, Class<? extends Statistic>> regulars = new ConcurrentHashMap<Class<? extends Statistic>, Class<? extends Statistic>>();
    @Nonnull
    private final T dummyInstance;
    @Nonnull
    private final String name;
    @Nonnull
    private final String description;
    @Nonnull
    private final ReflectFactory<T> regularFactory;
    @Nonnull
    private final ReflectFactory<T> dummyFactory;

    public StatisticId(@Nonnull String name, @Nonnull String description, @Nonnull Class<? extends T> regularClass, @Nonnull Class<? extends T> dummyClass) {
        this.name = name;
        this.description = description;
        this.regularFactory = new ReflectFactory<T>(regularClass, false, StatisticId.class);
        this.dummyFactory = new ReflectFactory<T>(dummyClass, false, StatisticId.class);
        this.dummyInstance = (Statistic)this.dummyFactory.create(this);
        if (!dummies.containsKey(dummyClass)) {
            dummies.put((Class<? extends Statistic>)dummyClass, (Statistic)this.dummyInstance);
            regulars.put(dummyClass, regularClass);
        }
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public T newInstance() {
        return (T)((Statistic)this.regularFactory.create(this));
    }

    @Nonnull
    public T getDummyInstance() {
        return this.dummyInstance;
    }

    @Nonnull
    @Deprecated
    public static synchronized Collection<? extends Statistic> getDummies() {
        return dummies.values();
    }

    @Nonnull
    @Deprecated
    public static Class<? extends Statistic> getRegularClass(@Nonnull Class<? extends Statistic> dummyClass) {
        return regulars.get(dummyClass);
    }

    @Nonnull
    public String toString() {
        return this.name;
    }
}

