/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.stats;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.log.stats.ExtendedSample;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import java.util.Arrays;

public class ExtendedSampleImpl
extends ExtendedSample {
    private static final int INITIAL_CAPACITY = 16;
    private static final int INCREMENT = 0;
    @Nonnull
    protected double[] samples = new double[16];
    @Nonnegative
    private int validCount;
    @Nonnegative
    private int nanCount;
    private double total;
    private boolean isSorted = true;
    private double min = Double.POSITIVE_INFINITY;
    @CheckForNull
    private Object minObject;
    private double max = Double.NEGATIVE_INFINITY;
    @CheckForNull
    private Object maxObject;
    @Nonnegative
    private final int increment;

    public ExtendedSampleImpl(@Nonnull StatisticId<? extends Statistic> id) {
        super(id);
        this.increment = 0;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public synchronized void add(double value) {
        this.add(value, null);
    }

    @Override
    public synchronized void add(double value, @CheckForNull Object obj) {
        if (!Double.isNaN(value)) {
            this.ensureCapacity(this.validCount);
            this.samples[this.validCount++] = value;
            this.isSorted = false;
            if (value < this.min) {
                this.min = value;
                this.minObject = obj;
            }
            if (value > this.max) {
                this.max = value;
                this.maxObject = obj;
            }
            this.total += value;
        } else {
            ++this.nanCount;
        }
    }

    @Override
    @Nonnegative
    public int getCount() {
        return this.validCount;
    }

    @Override
    @Nonnegative
    public int getNaNCount() {
        return this.nanCount;
    }

    @Override
    public double getTotal() {
        return this.total;
    }

    @Override
    public synchronized double getMin() {
        return this.min;
    }

    @Override
    public synchronized double getAverage() {
        return this.total / (double)this.validCount;
    }

    @Override
    public synchronized double getMax() {
        return this.max;
    }

    @Override
    @CheckForNull
    public Object getMinObject() {
        return this.minObject;
    }

    @Override
    @CheckForNull
    public Object getMaxObject() {
        return this.maxObject;
    }

    @Override
    public synchronized double getFirstQuartile() {
        return this.getNth(1, 4);
    }

    @Override
    public synchronized double getMedian() {
        return this.getNth(1, 2);
    }

    @Override
    public synchronized double getThirdQuartile() {
        return this.getNth(3, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void merge(@Nonnull Statistic statistic) {
        ExtendedSampleImpl samples;
        ExtendedSampleImpl extendedSampleImpl = samples = (ExtendedSampleImpl)statistic;
        synchronized (extendedSampleImpl) {
            this.ensureCapacity(this.validCount + samples.validCount);
            System.arraycopy(samples.samples, 0, this.samples, this.validCount, samples.validCount);
            this.total += samples.total;
            this.validCount += samples.validCount;
            this.nanCount += samples.nanCount;
            this.isSorted = false;
            if (samples.min < this.min) {
                this.min = samples.min;
                this.minObject = samples.minObject;
            }
            if (samples.max > this.max) {
                this.max = samples.max;
                this.maxObject = samples.maxObject;
            }
        }
    }

    @Override
    protected void ensureSorted() {
        if (!this.isSorted) {
            Arrays.sort(this.samples, 0, this.validCount);
            this.isSorted = true;
        }
    }

    private void ensureCapacity(@Nonnegative int goal) {
        if (goal >= this.samples.length) {
            int newLength;
            if (this.increment <= 0) {
                newLength = this.samples.length;
                while (goal >= newLength) {
                    newLength = newLength * 2 + 1;
                }
            } else {
                newLength = (goal + 0) / 0 * 0;
            }
            double[] newArray = new double[newLength];
            System.arraycopy(this.samples, 0, newArray, 0, this.validCount);
            this.samples = newArray;
        }
    }

    private double getNth(int n, int d) {
        this.ensureSorted();
        if (this.validCount == 0) {
            return Double.NaN;
        }
        if (this.validCount == 1) {
            return this.samples[0];
        }
        double pos = (double)(n * (this.validCount + 1)) / (double)d;
        if (pos < 1.0) {
            return this.samples[0];
        }
        double floor = Math.floor(pos);
        double diff = pos - floor;
        double vLow = this.samples[(int)pos - 1];
        if (diff == 0.0) {
            return vLow;
        }
        double vHigh = this.samples[(int)pos];
        return vLow + diff * (vHigh - vLow);
    }
}

