/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.location;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.location.Location;

public class ColumnAndLineLocation
implements Location {
    public static final int UNKNOWN = -1;
    private final int startLine;
    private int endLine = -1;
    private int startColumn = -1;
    private int endColumn = -1;
    @Nonnull
    private final Location parentLocation;

    public ColumnAndLineLocation(@Nonnull Location parentLocation, int line) {
        assert (line != -1);
        this.parentLocation = parentLocation;
        this.startLine = line;
    }

    public ColumnAndLineLocation(@Nonnull Location parentLocation, int startLine, int endLine) {
        assert (startLine != -1);
        if (endLine == startLine) {
            endLine = -1;
        }
        this.parentLocation = parentLocation;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public ColumnAndLineLocation(@Nonnull Location parentLocation, int startLine, int endLine, int startColumn, int endColumn) {
        assert (startLine != -1);
        assert (startColumn != -1 || endColumn == -1);
        if (endLine == startLine) {
            endLine = -1;
        }
        if (endColumn == startColumn) {
            endColumn = -1;
        }
        this.parentLocation = parentLocation;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
    }

    @Override
    @Nonnull
    public String getDescription() {
        assert (this.hasStartLine());
        StringBuilder sb = new StringBuilder();
        if (!this.parentLocation.getDescription().isEmpty()) {
            sb.append(this.parentLocation.getDescription()).append(", ");
        }
        if (!this.hasEndLine()) {
            sb.append("line ").append(this.startLine);
        } else {
            sb.append("from line ").append(this.startLine).append(" to ").append(this.endLine);
        }
        if (this.hasStartColumn()) {
            if (!this.hasEndColumn()) {
                sb.append(", column ").append(this.startColumn);
            } else {
                sb.append(", from column ").append(this.startColumn).append(" to ").append(this.endColumn);
            }
        }
        return sb.toString();
    }

    @Nonnull
    public Location getParentLocation() {
        return this.parentLocation;
    }

    @Nonnegative
    public int getStartLine() {
        assert (this.hasStartLine());
        return this.startLine;
    }

    @Nonnegative
    public int getEndLine() {
        assert (this.hasEndLine());
        return this.endLine;
    }

    @Nonnegative
    public int getStartColumn() {
        assert (this.hasStartColumn());
        return this.startColumn;
    }

    @Nonnegative
    public int getEndColumn() {
        assert (this.hasEndColumn());
        return this.endColumn;
    }

    public boolean hasStartLine() {
        return this.startLine != -1;
    }

    public boolean hasEndLine() {
        return this.endLine != -1;
    }

    public boolean hasStartColumn() {
        return this.startColumn != -1;
    }

    public boolean hasEndColumn() {
        return this.endColumn != -1;
    }

    public final boolean equals(Object obj) {
        return obj instanceof ColumnAndLineLocation && ((ColumnAndLineLocation)obj).startLine == this.startLine && ((ColumnAndLineLocation)obj).endLine == this.endLine && ((ColumnAndLineLocation)obj).startColumn == this.startColumn && ((ColumnAndLineLocation)obj).endColumn == this.endColumn && ((ColumnAndLineLocation)obj).parentLocation.equals(this.parentLocation);
    }

    public final int hashCode() {
        return this.startLine * 13 ^ this.endLine * 27 ^ this.startColumn * 29 ^ this.endColumn * 31 ^ this.parentLocation.hashCode();
    }
}

