/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.LineSeparator;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.StandardOutputKind;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.stream.CustomPrintWriter;
import com.android.sched.util.stream.QueryableOutputStream;
import com.android.sched.util.stream.UncloseableOutputStream;
import com.android.sched.vfs.PrintWriterProvider;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;

public class WriterFile
extends AbstractStreamFile
implements PrintWriterProvider {
    @Nonnull
    private static final LineSeparator LINE_SEPARATOR = LineSeparator.SYSTEM;
    @Nonnegative
    private static final int BUFFER_SIZE = 8192;
    @CheckForNull
    private CustomPrintWriter writer;
    @Nonnull
    private final Charset charset;
    @Nonnull
    private final LineSeparator lineSeparator;
    @Nonnegative
    private final int bufferSize;
    private final boolean append;

    public WriterFile(@Nonnull String name, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, boolean append) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        this(new File(name), Charset.defaultCharset(), LINE_SEPARATOR, new FileLocation(name), hooks, existence, change, append);
    }

    public WriterFile(@Nonnull String name, @Nonnull Charset charset, @Nonnull LineSeparator lineSeparator, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, boolean append) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        this(new File(name), charset, lineSeparator, new FileLocation(name), hooks, existence, change, append);
    }

    public WriterFile(@CheckForNull Directory workingDirectory, @Nonnull String name, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, boolean append) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        this(WriterFile.getFileFromWorkingDirectory(workingDirectory, name), Charset.defaultCharset(), LINE_SEPARATOR, new FileLocation(name), hooks, existence, change, append);
    }

    public WriterFile(@CheckForNull Directory workingDirectory, @Nonnull String name, @Nonnull Charset charset, @Nonnull LineSeparator lineSeparator, @Nonnegative int bufferSize, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, boolean append) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        super(WriterFile.getFileFromWorkingDirectory(workingDirectory, name), new FileLocation(name), hooks);
        this.performChecks(existence, 2, change);
        this.append = append;
        this.charset = charset;
        this.lineSeparator = lineSeparator;
        this.bufferSize = bufferSize;
    }

    public WriterFile(@CheckForNull Directory workingDirectory, @Nonnull String name, @Nonnull Charset charset, @Nonnull LineSeparator lineSeparator, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, boolean append) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        this(WriterFile.getFileFromWorkingDirectory(workingDirectory, name), charset, lineSeparator, new FileLocation(name), hooks, existence, change, append);
    }

    protected WriterFile(@Nonnull File file, @Nonnull FileLocation location, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, boolean append) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        this(file, Charset.defaultCharset(), LINE_SEPARATOR, location, hooks, existence, change, append);
    }

    protected WriterFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull LineSeparator lineSeparator, @Nonnull FileLocation location, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, @Nonnull FileOrDirectory.ChangePermission change, boolean append) throws FileAlreadyExistsException, CannotCreateFileException, CannotChangePermissionException, WrongPermissionException, NoSuchFileException, NotFileException {
        super(file, location, hooks);
        this.performChecks(existence, 2, change);
        this.append = append;
        this.charset = charset;
        this.lineSeparator = lineSeparator;
        this.bufferSize = 8192;
    }

    public WriterFile(@Nonnull String name, @CheckForNull RunnableHooks hooks) throws CannotCreateFileException, WrongPermissionException, NotFileException {
        this(name, Charset.defaultCharset(), LINE_SEPARATOR, hooks);
    }

    public WriterFile(@Nonnull String name, @Nonnull Charset charset, @Nonnull LineSeparator lineSeperator, @CheckForNull RunnableHooks hooks) throws CannotCreateFileException, WrongPermissionException, NotFileException {
        super(name, hooks);
        try {
            this.performChecks(FileOrDirectory.Existence.MAY_EXIST, 2, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (NoSuchFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        this.charset = charset;
        this.append = false;
        this.lineSeparator = lineSeperator;
        this.bufferSize = 8192;
    }

    public WriterFile(@Nonnull String name) throws WrongPermissionException, NotFileException {
        this(name, Charset.defaultCharset(), LINE_SEPARATOR);
    }

    public WriterFile(@Nonnull String name, @Nonnull Charset charset, @Nonnull LineSeparator lineSeparator) throws WrongPermissionException, NotFileException {
        super(name, null);
        try {
            this.performChecks(FileOrDirectory.Existence.MUST_EXIST, 2, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (NoSuchFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        this.charset = charset;
        this.append = false;
        this.lineSeparator = lineSeparator;
        this.bufferSize = 8192;
    }

    public WriterFile(@Nonnull StandardOutputKind standardOutputKind) {
        this(standardOutputKind, Charset.defaultCharset(), LineSeparator.SYSTEM);
    }

    public WriterFile(@Nonnull StandardOutputKind standardOutputKind, @Nonnull Charset charset, @Nonnull LineSeparator lineSeparator) {
        this(standardOutputKind.getOutputStream(), charset, lineSeparator, standardOutputKind.getLocation());
    }

    public WriterFile(@Nonnull OutputStream stream, @Nonnull Location location) {
        this(stream, Charset.defaultCharset(), LINE_SEPARATOR, location);
    }

    public WriterFile(@Nonnull OutputStream stream, @Nonnull Charset charset, @Nonnull LineSeparator lineSeparator, @Nonnegative int bufferSize, @Nonnull Location location) {
        super(location);
        this.charset = charset;
        this.append = true;
        this.lineSeparator = lineSeparator;
        this.bufferSize = bufferSize;
        this.stream = new QueryableOutputStream(new UncloseableOutputStream(stream));
        this.writer = this.getCustomPrintWriter((OutputStream)((Object)this.stream));
    }

    public WriterFile(@Nonnull OutputStream stream, @Nonnull Charset charset, @Nonnull LineSeparator lineSeparator, @Nonnull Location location) {
        super(location);
        this.charset = charset;
        this.append = true;
        this.lineSeparator = lineSeparator;
        this.bufferSize = 8192;
        this.stream = new QueryableOutputStream(new UncloseableOutputStream(stream));
        this.writer = this.getCustomPrintWriter((OutputStream)((Object)this.stream));
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public synchronized CustomPrintWriter getPrintWriter() {
        this.wasUsed = true;
        if (this.writer == null) {
            this.clearRemover();
            try {
                this.stream = new QueryableOutputStream(new FileOutputStream(this.file, this.append));
                this.writer = this.getCustomPrintWriter((OutputStream)((Object)this.stream));
            }
            catch (FileNotFoundException e) {
                throw new ConcurrentIOException(e);
            }
        }
        return this.writer;
    }

    @Nonnull
    private CustomPrintWriter getCustomPrintWriter(@Nonnull OutputStream os) {
        Writer tmp = new OutputStreamWriter(os, this.charset);
        if (this.bufferSize > 0) {
            tmp = new BufferedWriter(tmp, this.bufferSize);
        }
        return new CustomPrintWriter(tmp, this.lineSeparator.getLineSeparator());
    }

    public boolean isInAppendMode() {
        return this.append;
    }

    @Nonnull
    public Charset getCharset() {
        return this.charset;
    }

    @Nonnull
    public LineSeparator getLineSeparator() {
        return this.lineSeparator;
    }
}

