/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.file.AbstractStreamFile;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.FileLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.StandardInputLocation;
import com.android.sched.util.stream.QueryableInputStream;
import com.android.sched.util.stream.UncloseableInputStream;
import com.android.sched.vfs.InputStreamProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class InputStreamFile
extends AbstractStreamFile
implements InputStreamProvider {
    public InputStreamFile(@Nonnull String name) throws WrongPermissionException, NotFileException, NoSuchFileException {
        this(new File(name), new FileLocation(name));
    }

    public InputStreamFile() {
        super(new StandardInputLocation());
        this.stream = new QueryableInputStream(new UncloseableInputStream(System.in));
    }

    public InputStreamFile(@Nonnull InputStream in, @Nonnull Location location) {
        super(location);
        this.stream = new QueryableInputStream(new UncloseableInputStream(in));
    }

    public InputStreamFile(@CheckForNull Directory workingDirectory, @Nonnull String string) throws NotFileException, WrongPermissionException, NoSuchFileException {
        this(InputStreamFile.getFileFromWorkingDirectory(workingDirectory, string), new FileLocation(string));
    }

    private InputStreamFile(@Nonnull File file, @Nonnull FileLocation location) throws WrongPermissionException, NotFileException, NoSuchFileException {
        super(file, location, null);
        try {
            this.performChecks(FileOrDirectory.Existence.MUST_EXIST, 1, FileOrDirectory.ChangePermission.NOCHANGE);
        }
        catch (FileAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotCreateFileException e) {
            throw new AssertionError((Object)e);
        }
        catch (CannotChangePermissionException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @Nonnull
    public synchronized InputStream getInputStream() {
        this.wasUsed = true;
        if (this.stream == null) {
            this.clearRemover();
            try {
                this.stream = new QueryableInputStream(new FileInputStream(this.file));
            }
            catch (FileNotFoundException e) {
                throw new ConcurrentIOException(e);
            }
        }
        return (InputStream)((Object)this.stream);
    }
}

