/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.ConcurrentIOException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.InputZipFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.NotJarFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.FileLocation;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

public class InputJarFile
extends InputZipFile {
    public InputJarFile(@Nonnull String path) throws WrongPermissionException, NotFileException, NoSuchFileException, NotJarFileException {
        this(new File(path), new FileLocation(path));
    }

    public InputJarFile(@CheckForNull Directory workingDirectory, @Nonnull String path) throws NotFileException, WrongPermissionException, NoSuchFileException, NotJarFileException {
        this(InputJarFile.getFileFromWorkingDirectory(workingDirectory, path), new FileLocation(path));
    }

    protected InputJarFile(@Nonnull File file, @Nonnull FileLocation location) throws WrongPermissionException, NoSuchFileException, NotFileException, NotJarFileException {
        super(file, location, InputJarFile.processJar(file, location));
    }

    @Nonnull
    private static JarFile processJar(@Nonnull File file, @Nonnull FileLocation location) throws NotJarFileException {
        try {
            return new JarFile(file);
        }
        catch (ZipException e) {
            throw new NotJarFileException(location, (Throwable)e);
        }
        catch (IOException e) {
            throw new ConcurrentIOException(e);
        }
    }

    @Nonnull
    public JarFile getJarFile() {
        return (JarFile)this.getZipFile();
    }

    @Nonnull
    public File getFile() {
        assert (this.file != null);
        return this.file;
    }
}

