/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.file;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.DirectoryLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.LoggerFactory;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Directory
extends FileOrDirectory {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final File file;

    public Directory(@Nonnull String name, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, int permissions, @Nonnull FileOrDirectory.ChangePermission change) throws WrongPermissionException, CannotChangePermissionException, NoSuchFileException, NotDirectoryException, FileAlreadyExistsException, CannotCreateFileException {
        this(new File(name), new DirectoryLocation(name), hooks, existence, permissions, change);
    }

    public Directory(@CheckForNull Directory workingDirectory, @Nonnull String string, @CheckForNull RunnableHooks runnableHooks, @Nonnull FileOrDirectory.Existence existence, int permissions, @Nonnull FileOrDirectory.ChangePermission change) throws NotDirectoryException, WrongPermissionException, CannotChangePermissionException, NoSuchFileException, FileAlreadyExistsException, CannotCreateFileException {
        this(Directory.getFileFromWorkingDirectory(workingDirectory, string), new DirectoryLocation(string), runnableHooks, existence, permissions, change);
    }

    private Directory(@Nonnull File file, @Nonnull DirectoryLocation location, @CheckForNull RunnableHooks hooks, @Nonnull FileOrDirectory.Existence existence, int permissions, @Nonnull FileOrDirectory.ChangePermission change) throws WrongPermissionException, CannotChangePermissionException, NoSuchFileException, NotDirectoryException, FileAlreadyExistsException, CannotCreateFileException {
        super(hooks);
        this.file = file;
        this.location = location;
        if (existence == FileOrDirectory.Existence.MAY_EXIST) {
            existence = file.exists() ? FileOrDirectory.Existence.MUST_EXIST : FileOrDirectory.Existence.NOT_EXIST;
        }
        switch (existence) {
            case MUST_EXIST: {
                Directory.check(file, location);
                FileOrDirectory.checkPermissions(file, location, permissions);
                break;
            }
            case NOT_EXIST: {
                Directory.create(file, location);
                this.addRemover(file);
                FileOrDirectory.setPermissions(file, location, permissions, change);
                FileOrDirectory.checkPermissions(file, location, permissions);
                break;
            }
            case MAY_EXIST: {
                throw new AssertionError();
            }
        }
    }

    @Nonnull
    public File getFile() {
        this.clearRemover();
        return this.file;
    }

    @Nonnull
    public String toString() {
        return this.location.getDescription();
    }

    public static void check(@Nonnull File file, @Nonnull DirectoryLocation location) throws NoSuchFileException, NotDirectoryException {
        if (!file.exists()) {
            throw new NoSuchFileException(location);
        }
        if (!file.isDirectory()) {
            throw new NotDirectoryException(location);
        }
    }

    public static void create(@Nonnull File file, @Nonnull Location location) throws FileAlreadyExistsException, CannotCreateFileException {
        if (!file.mkdir()) {
            if (!file.exists()) {
                throw new CannotCreateFileException(location);
            }
            throw new FileAlreadyExistsException(location);
        }
        logger.log(Level.FINE, "Create {0} (''{1}'')", new Object[]{location.getDescription(), file.getAbsoluteFile()});
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.file.getPath();
    }
}

