/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.HasDescription;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.KeyId;
import java.util.ArrayList;
import java.util.List;

public class PropertyId<T>
extends KeyId<T, String>
implements HasDescription {
    @Nonnull
    private final String description;
    @Nonnull
    private final StringCodec<T> codec;
    @CheckForNull
    private ShutdownRunnable<T> shutdownRunner;
    @Nonnull
    private final List<Value> defaultValues = new ArrayList<Value>(1);
    @CheckForNull
    private Value defaultValue = null;
    private boolean defaultValueAvailable = false;

    @Nonnull
    public static <T> PropertyId<T> create(@Nonnull String name, @Nonnull String description, @Nonnull StringCodec<T> codec) {
        return new PropertyId<T>(name, description, codec);
    }

    protected PropertyId(@Nonnull String name, @Nonnull String description, @Nonnull StringCodec<T> codec) {
        super(name);
        this.description = description;
        this.codec = codec;
    }

    @Nonnull
    public PropertyId<T> setShutdownHook(@Nonnull ShutdownRunnable<T> shutdownRunner) {
        this.shutdownRunner = shutdownRunner;
        return this;
    }

    @Nonnull
    public PropertyId<T> removeShutdownHook() {
        this.shutdownRunner = null;
        return this;
    }

    @Nonnull
    public PropertyId<T> addDefaultValue(@Nonnull String defaultValue) {
        this.defaultValues.add(new Value(defaultValue));
        return this;
    }

    @Nonnull
    public PropertyId<T> addDefaultValue(@Nonnull T defaultValue) {
        this.defaultValues.add(new Value(defaultValue));
        return this;
    }

    @CheckForNull
    public Value getDefaultValue(@Nonnull CodecContext context) {
        if (!this.defaultValueAvailable) {
            ParsingException lastException = null;
            for (Value value : this.getDefaultValues()) {
                try {
                    value.check(context);
                    this.defaultValue = value;
                    break;
                }
                catch (ParsingException e) {
                    lastException = e;
                }
            }
            if (this.defaultValue == null && lastException != null) {
                throw new ConfigurationError("Property '" + this.getName() + "': " + lastException.getMessage());
            }
            this.defaultValueAvailable = true;
        }
        return this.defaultValue;
    }

    @Nonnull
    public List<Value> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public PropertyId<T> addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory(category);
        return this;
    }

    @Nonnull
    public PropertyId<T> addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }

    @Nonnull
    public StringCodec<T> getCodec() {
        return this.codec;
    }

    @Nonnull
    public PropertyId<T> requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    private class IValueObject<T>
    implements IValue<T> {
        @Nonnull
        private final T value;

        public IValueObject(T value) {
            this.value = value;
        }

        public IValueObject(@Nonnull CodecContext context, final T value) {
            RunnableHooks hooks;
            final ShutdownRunnable shutdownRunner = PropertyId.this.shutdownRunner;
            if (shutdownRunner != null && (hooks = context.getRunnableHooks()) != null) {
                hooks.addHook(new Runnable(){

                    @Override
                    public void run() {
                        shutdownRunner.run(value);
                    }
                });
            }
            this.value = value;
        }

        @Override
        @Nonnull
        public String getString() {
            return PropertyId.this.codec.formatValue(this.value);
        }

        @Override
        @Nonnull
        public IValue<T> check(@Nonnull CodecContext context) throws ParsingException {
            try {
                PropertyId.this.codec.checkValue(context, this.value);
            }
            catch (CheckingException e) {
                throw new ParsingException(e.getMessage());
            }
            return this;
        }

        @Override
        @Nonnull
        public IValueObject<T> getValueObject(@Nonnull CodecContext context) {
            return this;
        }

        @Nonnull
        public T getObject() {
            return this.value;
        }

        @Override
        @Nonnull
        public IValue<T> duplicate() {
            PropertyId propertyId = PropertyId.this;
            propertyId.getClass();
            return propertyId.new IValueCheckedString(this.getString());
        }
    }

    private class IValueCheckedString
    implements IValue<T> {
        @Nonnull
        private final String value;

        private IValueCheckedString(String value) {
            this.value = value;
        }

        @Override
        public String getString() {
            return this.value;
        }

        @Override
        @Nonnull
        public IValue<T> check(@Nonnull CodecContext context) {
            return this;
        }

        @Override
        @Nonnull
        public IValueObject<T> getValueObject(@Nonnull CodecContext context) {
            return new IValueObject(context, PropertyId.this.codec.parseString(context, this.value));
        }

        @Override
        @Nonnull
        public IValue<T> duplicate() {
            return this;
        }
    }

    private class IValueString
    implements IValue<T> {
        @Nonnull
        private final String value;

        public IValueString(String value) {
            this.value = value;
        }

        @Override
        public String getString() {
            return this.value;
        }

        @Override
        @Nonnull
        public IValue<T> check(@Nonnull CodecContext context) throws ParsingException {
            Object val = PropertyId.this.codec.checkString(context, this.value);
            if (val != null) {
                return new IValueObject(context, val);
            }
            return new IValueCheckedString(this.value);
        }

        @Override
        @Nonnull
        public IValueObject<T> getValueObject(@Nonnull CodecContext context) {
            throw new AssertionError();
        }

        @Override
        @Nonnull
        public IValue<T> duplicate() {
            return this;
        }
    }

    private static interface IValue<T> {
        @Nonnull
        public IValue<T> check(@Nonnull CodecContext var1) throws ParsingException;

        @Nonnull
        public IValueObject<T> getValueObject(@Nonnull CodecContext var1);

        @Nonnull
        public String getString();

        @Nonnull
        public IValue<T> duplicate();
    }

    public class Value {
        @Nonnull
        private IValue<T> value;

        public Value(T value) {
            this.value = new IValueObject(value);
        }

        private Value(IValue<T> value) {
            this.value = value.duplicate();
        }

        @Nonnull
        public synchronized Value duplicate() {
            return new Value(this.value);
        }

        public Value(@Nonnull CodecContext context, T value) {
            this.value = new IValueObject(context, value);
        }

        public Value(String value) {
            this.value = new IValueString(value);
        }

        public synchronized void check(@Nonnull CodecContext context) throws ParsingException {
            this.value = this.value.check(context);
        }

        @Nonnull
        public String getString() {
            return this.value.getString();
        }

        @Nonnull
        public synchronized T getObject(@Nonnull CodecContext context) {
            this.value = this.value.getValueObject(context);
            return ((IValueObject)this.value).getObject();
        }

        @CheckForNull
        public synchronized T getObjectIfAny() {
            if (this.value instanceof IValueObject) {
                return ((IValueObject)this.value).getObject();
            }
            return null;
        }
    }

    public static interface ShutdownRunnable<T> {
        public void run(@Nonnull T var1);
    }
}

