/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.OutputStreamCodec;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.file.OutputStreamFile;
import com.android.sched.util.file.StreamFileStatus;
import com.android.sched.util.log.LoggerFactory;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutputStreamFilePropertyId
extends PropertyId<OutputStreamFile> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    @Nonnull
    public static OutputStreamFilePropertyId create(@Nonnull String name, @Nonnull String description, @Nonnull OutputStreamCodec codec) {
        return new OutputStreamFilePropertyId(name, description, codec);
    }

    protected OutputStreamFilePropertyId(@Nonnull String name, @Nonnull String description, @Nonnull OutputStreamCodec codec) {
        super(name, description, codec);
        this.withAutoCheck();
    }

    @Nonnull
    public OutputStreamFilePropertyId withAutoClose() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<OutputStreamFile>(){

            @Override
            public void run(OutputStreamFile file) {
                if (file.getStatus() == StreamFileStatus.OPEN) {
                    try {
                        file.getOutputStream().close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Failed to close " + file.getLocation().getDescription() + " from property '" + OutputStreamFilePropertyId.this.getName() + "'", e);
                    }
                }
            }
        });
        return this;
    }

    @Nonnull
    public OutputStreamFilePropertyId withAutoCheck() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<OutputStreamFile>(){

            @Override
            public void run(OutputStreamFile file) {
                if (file.getStatus() == StreamFileStatus.OPEN) {
                    throw new AssertionError((Object)(file.getLocation().getDescription() + " from property '" + OutputStreamFilePropertyId.this.getName() + "' is not closed"));
                }
            }
        });
        return this;
    }

    @Nonnull
    public OutputStreamFilePropertyId withoutAutoAction() {
        this.removeShutdownHook();
        return this;
    }

    @Nonnull
    public OutputStreamFilePropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public OutputStreamFilePropertyId addDefaultValue(@Nonnull OutputStreamFile defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public OutputStreamFilePropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public OutputStreamCodec getCodec() {
        return (OutputStreamCodec)super.getCodec();
    }

    @Nonnull
    public OutputStreamFilePropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public OutputStreamFilePropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }
}

