/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.LongCodec;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.MissingPropertyException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.expression.LongExpression;
import com.android.sched.util.config.id.PropertyId;

public class LongPropertyId
extends PropertyId<Long> {
    @Nonnull
    public static LongPropertyId create(@Nonnull String name, @Nonnull String description) {
        return new LongPropertyId(name, description, new LongCodec(Long.MIN_VALUE, Long.MAX_VALUE));
    }

    protected LongPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull LongCodec parser) {
        super(name, description, parser);
    }

    @Nonnull
    public LongPropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public LongPropertyId addDefaultValue(@Nonnull Long defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public LongPropertyId addDefaultValue(@Nonnull long defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public LongPropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public LongCodec getCodec() {
        return (LongCodec)super.getCodec();
    }

    @Nonnull
    public LongPropertyId withMin(long min) {
        this.getCodec().setMin(min);
        return this;
    }

    @Nonnull
    public LongPropertyId withMax(long max) {
        this.getCodec().setMax(max);
        return this;
    }

    @Nonnull
    public LongExpression getValue() {
        return new LongExpression(){

            @Override
            public long eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!LongPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(LongPropertyId.this);
                }
                return checker.parse(LongPropertyId.this);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return this.formatPropertyName(LongPropertyId.this);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return this.formatPropertyName(checker, LongPropertyId.this);
            }
        };
    }

    @Nonnull
    public LongPropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public LongPropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }
}

