/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.expression.PropertyNotRequiredException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class KeyId<T, S> {
    @Nonnull
    private final String name;
    @Nonnull
    private final Map<Class<? extends Category>, Category> categories = new HashMap<Class<? extends Category>, Category>(2);
    @CheckForNull
    private BooleanExpression requiredIf;

    public KeyId(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Collection<Class<? extends Category>> getCategories() {
        return Collections.unmodifiableCollection(this.categories.keySet());
    }

    @Nonnull
    public KeyId<T, S> addCategory(@Nonnull Class<? extends Category> category) {
        if (this.hasCategory(category)) {
            throw new ConfigurationError("Duplicate category " + category.getCanonicalName());
        }
        this.categories.put(category, null);
        return this;
    }

    @Nonnull
    public KeyId<T, S> addCategory(@Nonnull Category category) {
        if (this.hasCategory(category.getClass())) {
            throw new ConfigurationError("Duplicate category " + category.getClass().getCanonicalName());
        }
        this.categories.put(category.getClass(), category);
        return this;
    }

    public boolean hasDirectCategory(@Nonnull Class<? extends Category> target) {
        return target == Category.class || this.categories.containsKey(target);
    }

    @CheckForNull
    public Category getDirectCategory(@Nonnull Class<? extends Category> target) {
        if (target == Category.class) {
            return null;
        }
        if (this.categories.containsKey(target)) {
            return this.categories.get(target);
        }
        throw new NoSuchElementException();
    }

    public boolean hasCategory(@Nonnull Class<? extends Category> target) {
        if (target == Category.class) {
            return true;
        }
        for (Class<? extends Category> category : this.categories.keySet()) {
            if (!target.isAssignableFrom(category)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public <T extends Category> T getCategory(@Nonnull Class<T> target) {
        if (target == Category.class) {
            return null;
        }
        for (Map.Entry<Class<? extends Category>, Category> entry : this.categories.entrySet()) {
            if (!target.isAssignableFrom(entry.getKey())) continue;
            return (T)entry.getValue();
        }
        throw new NoSuchElementException();
    }

    @Nonnull
    public KeyId<T, S> requiredIf(@Nonnull BooleanExpression expression) {
        this.requiredIf = expression;
        return this;
    }

    @CheckForNull
    public BooleanExpression getRequiredExpression() {
        return this.requiredIf;
    }

    public boolean isRequired(@Nonnull ConfigChecker checker) throws PropertyIdException {
        if (this.requiredIf == null) {
            return true;
        }
        try {
            return this.requiredIf.eval(checker);
        }
        catch (PropertyNotRequiredException e) {
            return false;
        }
    }

    @Nonnull
    public String toString() {
        return this.name;
    }
}

