/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.LongCodec;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.LongPropertyId;

public class IntegerPropertyId
extends LongPropertyId {
    @Nonnull
    public static IntegerPropertyId create(@Nonnull String name, @Nonnull String description) {
        return new IntegerPropertyId(name, description, new LongCodec(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    protected IntegerPropertyId(@Nonnull String name, @Nonnull String description, @Nonnull LongCodec parser) {
        super(name, description, parser);
    }

    @Override
    @Nonnull
    public IntegerPropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public IntegerPropertyId addDefaultValue(@Nonnull Integer defaultValue) {
        super.addDefaultValue((Long)defaultValue.longValue());
        return this;
    }

    @Nonnull
    public IntegerPropertyId addDefaultValue(@Nonnull int defaultValue) {
        super.addDefaultValue(Long.valueOf(defaultValue));
        return this;
    }

    @Override
    @Nonnull
    public IntegerPropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Override
    @Nonnull
    public IntegerPropertyId withMin(long min) {
        assert (this.checkRange(min));
        super.withMin(min);
        return this;
    }

    @Override
    @Nonnull
    public IntegerPropertyId withMax(long max) {
        assert (this.checkRange(max));
        super.withMax(max);
        return this;
    }

    private boolean checkRange(long value) {
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    @Override
    @Nonnull
    public IntegerPropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public IntegerPropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }
}

