/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.expression;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.expression.Expression;
import com.android.sched.util.config.expression.PropertyNotRequiredException;

public abstract class DoubleExpression
extends Expression {
    public abstract double eval(@Nonnull ConfigChecker var1) throws PropertyIdException, PropertyNotRequiredException;

    @Nonnull
    public BooleanExpression isEqual(final @Nonnull DoubleExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return DoubleExpression.this.eval(checker) == right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return DoubleExpression.this.getDescription() + " is equal to " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return DoubleExpression.this.format(DoubleExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), DoubleExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isNotEqual(final @Nonnull DoubleExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return DoubleExpression.this.eval(checker) != right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return DoubleExpression.this.getDescription() + " is not equal to " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return DoubleExpression.this.format(DoubleExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), DoubleExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isGreater(final @Nonnull DoubleExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return DoubleExpression.this.eval(checker) > right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return DoubleExpression.this.getDescription() + " is greater than " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return DoubleExpression.this.format(DoubleExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), DoubleExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isGreaterOrEqual(final @Nonnull DoubleExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return DoubleExpression.this.eval(checker) >= right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return DoubleExpression.this.getDescription() + " is greater or equal than " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return DoubleExpression.this.format(DoubleExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), DoubleExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isLower(final @Nonnull DoubleExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return DoubleExpression.this.eval(checker) < right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return DoubleExpression.this.getDescription() + " is lower than " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return DoubleExpression.this.format(DoubleExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), DoubleExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public BooleanExpression isLowerOrEqual(final @Nonnull DoubleExpression right) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, PropertyNotRequiredException {
                return DoubleExpression.this.eval(checker) <= right.eval(checker);
            }

            @Override
            @Nonnull
            public String getDescription() {
                return DoubleExpression.this.getDescription() + " is lower or equal than " + right.getDescription();
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return DoubleExpression.this.format(DoubleExpression.this.getCause(checker), this.eval(checker), right.getCause(checker), DoubleExpression.this.eval(checker), right.eval(checker));
                }
                catch (PropertyNotRequiredException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public static DoubleExpression getConstant(final double value) {
        return new DoubleExpression(){

            @Override
            public double eval(@Nonnull ConfigChecker checker) {
                return value;
            }

            @Override
            @Nonnull
            public String getDescription() {
                return Double.toString(value);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return Double.toString(value);
            }
        };
    }

    @Nonnull
    private String format(@Nonnull String left, boolean eval, @Nonnull String right, double lhs, double rhs) {
        StringBuilder sb = new StringBuilder();
        if (!eval) {
            double tmp = lhs;
            lhs = rhs;
            rhs = tmp;
        }
        sb.append(left);
        if (lhs < rhs) {
            sb.append(" is lower than ");
        } else if (lhs > rhs) {
            sb.append(" is greater than ");
        } else {
            sb.append(" is equal to ");
        }
        sb.append(right);
        return sb.toString();
    }
}

