/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.jill.javax.annotation.Nonnull;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class ReflectFactory<T> {
    @Nonnull
    private final Constructor<? extends T> ctor;
    @Nonnull
    private final Class<? extends T> cls;

    public ReflectFactory(@Nonnull Class<? extends T> cls, boolean respectAccessibility, Class<?> ... argsType) {
        assert (this.checkAssertion(cls));
        this.cls = cls;
        try {
            this.ctor = cls.getDeclaredConstructor(argsType);
            if (!respectAccessibility) {
                this.ctor.setAccessible(true);
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("Constructor '" + this.toString(cls, argsType) + "' is not found"));
        }
    }

    @Nonnull
    private StringBuilder toString(@Nonnull Class<? extends T> cls, Class<?> ... argsType) {
        StringBuilder sb = new StringBuilder();
        sb.append(cls.getName());
        sb.append('(');
        boolean first = true;
        for (Class<?> argType : argsType) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(argType.getName());
        }
        sb.append(')');
        return sb;
    }

    private boolean checkAssertion(@Nonnull Class<? extends T> cls) {
        if (cls.isInterface()) {
            throw new AssertionError((Object)("Type '" + cls.getName() + "' is an interface"));
        }
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new AssertionError((Object)("Type '" + cls.getName() + "' is an abstract class"));
        }
        return true;
    }

    @Nonnull
    public T create(Object ... args) {
        try {
            return this.ctor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new AssertionError();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Constructor '" + this.ctor + "' is not accessible"));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Nonnull
    public Class<? extends T> getInstanciatedClass() {
        return this.cls;
    }
}

