/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.config.DefaultFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

public class ReflectDefaultCtorFactory<T>
implements DefaultFactory<T> {
    @Nonnull
    private final Constructor<? extends T> ctor;
    @Nonnull
    private final Class<? extends T> cls;

    public ReflectDefaultCtorFactory(@Nonnull Class<? extends T> cls, boolean respectAccessibility) {
        assert (this.checkAssertion(cls));
        this.cls = cls;
        try {
            this.ctor = cls.getDeclaredConstructor(new Class[0]);
            if (!respectAccessibility) {
                this.ctor.setAccessible(true);
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)("Default constructor is not found in '" + cls.getName() + '\''));
        }
    }

    private boolean checkAssertion(@Nonnull Class<? extends T> cls) {
        if (cls.isInterface()) {
            throw new AssertionError((Object)("Type '" + cls.getName() + "' is an interface"));
        }
        if (Modifier.isAbstract(cls.getModifiers())) {
            throw new AssertionError((Object)("Type '" + cls.getName() + "' is an abstract class"));
        }
        return true;
    }

    @Override
    @Nonnull
    public T create() {
        try {
            return this.ctor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new AssertionError();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Constructor '" + this.ctor + "' is not accessible"));
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    @Nonnull
    public Class<? extends T> getInstantiatedClass() {
        return this.cls;
    }
}

