/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.InternalConfig;
import com.android.sched.util.config.category.Private;
import com.android.sched.util.config.id.KeyId;
import com.android.sched.util.config.id.ObjectId;
import com.android.sched.util.config.id.PropertyId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class ConfigImpl
implements Config,
InternalConfig {
    @Nonnegative
    private static final AtomicInteger currentIndex = new AtomicInteger(0);
    @Nonnull
    private String name;
    @Nonnull
    private final CodecContext context;
    @Nonnull
    private final Map<PropertyId<?>, PropertyId.Value> valuesById = new HashMap();
    @Nonnull
    private final Map<KeyId<?, ?>, Object> instancesById = new HashMap();

    ConfigImpl(@Nonnull CodecContext context, @Nonnull Map<PropertyId<?>, PropertyId.Value> values, @Nonnull Map<KeyId<?, ?>, Object> instances) {
        this(context, values, instances, "config-" + currentIndex.getAndIncrement());
    }

    ConfigImpl(@Nonnull CodecContext context, @Nonnull Map<PropertyId<?>, PropertyId.Value> values, @Nonnull Map<KeyId<?, ?>, Object> instances, @Nonnull String name) {
        this.context = context;
        this.valuesById.putAll(values);
        this.instancesById.putAll(instances);
        this.name = name;
    }

    @Override
    @Nonnull
    public <T> T get(@Nonnull PropertyId<T> propertyId) {
        PropertyId.Value value = this.valuesById.get(propertyId);
        if (value == null) {
            throw new ConfigurationError("Property '" + propertyId.getName() + "' is unknown (see annotation @" + HasKeyId.class.getSimpleName() + " or requiredIf expression)");
        }
        return value.getObject(this.context);
    }

    @Override
    @Nonnull
    public <T> T parseAs(@Nonnull String string, @Nonnull PropertyId<T> propertyId) throws ParsingException {
        Object value = propertyId.getCodec().checkString(this.context, string);
        if (value == null) {
            value = propertyId.getCodec().parseString(this.context, string);
        }
        return value;
    }

    @Override
    @CheckForNull
    public <T> T getObjectIfAny(@Nonnull PropertyId<T> propertyId) {
        PropertyId.Value value = this.valuesById.get(propertyId);
        if (value == null) {
            throw new ConfigurationError("Property '" + propertyId.getName() + "' is unknown (see annotation @" + HasKeyId.class.getSimpleName() + " or requiredIf expression)");
        }
        return value.getObjectIfAny();
    }

    @Override
    public <T> boolean hasValue(@Nonnull PropertyId<T> propertyId) {
        return this.valuesById.get(propertyId) != null;
    }

    @Override
    @Nonnull
    public <T> String getAsString(@Nonnull PropertyId<T> propertyId) {
        PropertyId.Value value = this.valuesById.get(propertyId);
        if (value == null) {
            throw new ConfigurationError("Property '" + propertyId.getName() + "' is unknown (see annotation @" + HasKeyId.class.getSimpleName() + " or requiredIf expression)");
        }
        return value.getString();
    }

    @Override
    @Nonnull
    public synchronized <T> T get(@Nonnull ObjectId<T> objectId) {
        Object instance = this.instancesById.get(objectId);
        if (instance == null) {
            instance = objectId.createObject();
            this.instancesById.put(objectId, instance);
        }
        return (T)instance;
    }

    @Override
    @Nonnull
    public Collection<PropertyId<?>> getPropertyIds() {
        ArrayList result = new ArrayList(this.instancesById.size() + this.valuesById.size());
        for (KeyId keyId : this.valuesById.keySet()) {
            if (keyId.hasCategory(Private.class) || !(keyId instanceof PropertyId)) continue;
            result.add((PropertyId)keyId);
        }
        for (KeyId keyId : this.instancesById.keySet()) {
            if (keyId.hasCategory(Private.class) || !(keyId instanceof PropertyId)) continue;
            result.add((PropertyId)keyId);
        }
        return result;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }
}

