/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.config.ConfigImpl;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.id.KeyId;
import com.android.sched.util.config.id.ObjectId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.log.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

class ConfigDebug
extends ConfigImpl {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Map<KeyId<?, ?>, String> dropCauses;
    @Nonnull
    private final ThreadLocal<Stack<KeyId<?, ?>>> keyIds = new ThreadLocal<Stack<KeyId<?, ?>>>(){

        @Override
        protected Stack<KeyId<?, ?>> initialValue() {
            return new Stack();
        }
    };

    ConfigDebug(@Nonnull CodecContext context, @Nonnull Map<PropertyId<?>, PropertyId.Value> values, @Nonnull Map<KeyId<?, ?>, Object> instances, @Nonnull Map<KeyId<?, ?>, String> dropCauses) {
        super(context, values, instances);
        this.dropCauses = new HashMap(dropCauses);
    }

    ConfigDebug(@Nonnull CodecContext context, @Nonnull Map<PropertyId<?>, PropertyId.Value> values, @Nonnull Map<KeyId<?, ?>, Object> instances, @Nonnull Map<KeyId<?, ?>, String> dropCauses, @Nonnull String name) {
        super(context, values, instances, name);
        this.dropCauses = new HashMap(dropCauses);
    }

    @Override
    @Nonnull
    public synchronized <T> T get(@Nonnull PropertyId<T> propertyId) {
        Stack<KeyId<?, ?>> localKeyIds = this.keyIds.get();
        this.checkRecursivity(localKeyIds, propertyId);
        localKeyIds.push(propertyId);
        try {
            T t = super.get(propertyId);
            return t;
        }
        catch (ConfigurationError e) {
            throw this.getDetailedException(propertyId, e);
        }
        finally {
            localKeyIds.pop();
        }
    }

    @Override
    @Nonnull
    public synchronized <T> T get(@Nonnull ObjectId<T> objectId) {
        Stack<KeyId<?, ?>> localKeyIds = this.keyIds.get();
        this.checkRecursivity(localKeyIds, objectId);
        localKeyIds.push(objectId);
        try {
            T t = super.get(objectId);
            return t;
        }
        catch (ConfigurationError e) {
            throw this.getDetailedException(objectId, e);
        }
        finally {
            localKeyIds.pop();
        }
    }

    private ConfigurationError getDetailedException(@Nonnull KeyId<?, ?> keyId, @Nonnull ConfigurationError e) {
        String cause = this.dropCauses.get(keyId);
        if (cause != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(e.getMessage());
            sb.append(" (dropped because ");
            sb.append(this.dropCauses.get(keyId));
            sb.append(')');
            return new ConfigurationError(sb.toString(), e);
        }
        return e;
    }

    private void checkRecursivity(@Nonnull Stack<KeyId<?, ?>> localKeyIds, @Nonnull KeyId<?, ?> keyId) {
        if (localKeyIds.contains(keyId)) {
            this.logger.log(Level.SEVERE, "Recursivity during getting configuration:");
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            localKeyIds.push(keyId);
            StackTraceElement marker = stackTrace[1];
            for (int i = 1; i < stackTrace.length; ++i) {
                StackTraceElement trace = stackTrace[i];
                if (trace.getClassName().equals(marker.getClassName()) && trace.getMethodName().equals(marker.getMethodName()) && trace.getFileName().equals(marker.getFileName())) {
                    this.logger.log(Level.SEVERE, "  get ''{0}'' at:", localKeyIds.pop().getName());
                }
                this.logger.log(Level.SEVERE, "    {0}", trace);
            }
            throw new AssertionError((Object)("Recursive get of '" + keyId.getName() + "' (see log)"));
        }
    }
}

