/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.jill.google.common.base.CharMatcher;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.reflections.ReflectionFactory;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ChainedException;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.ConfigDebug;
import com.android.sched.util.config.ConfigImpl;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.ConfigurationException;
import com.android.sched.util.config.FormatConfigurationException;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.UnknownPropertyIdException;
import com.android.sched.util.config.UnknownPropertyNameException;
import com.android.sched.util.config.VariableDoesNotMatchConfigurationException;
import com.android.sched.util.config.VariableMatchesSeveralConfigurationException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.category.Private;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.KeyId;
import com.android.sched.util.config.id.ObjectId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.location.ColumnAndLineLocation;
import com.android.sched.util.location.ContainerLocation;
import com.android.sched.util.location.EnvironmentLocation;
import com.android.sched.util.location.FieldLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.NoLocation;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsapConfigBuilder {
    @Nonnull
    private static final Logger logger = Logger.getLogger(AsapConfigBuilder.class.getName());
    @Nonnull
    private static final NoLocation NO_LOCATION = new NoLocation();
    @Nonnull
    private final Map<String, KeyId<?, ?>> keyIdsByName = new HashMap();
    @Nonnull
    private final Map<KeyId<?, ?>, FieldLocation> defaultLocationsByKeyId = new HashMap();
    @Nonnull
    private final Map<PropertyId<?>, PropertyId.Value> valuesById = new HashMap();
    @Nonnull
    private final Map<KeyId<?, ?>, Location> valueLocationsByKeyId = new HashMap();
    @Nonnull
    private final Map<ObjectId<?>, Object> instances = new HashMap();
    @Nonnull
    private final Map<KeyId<?, ?>, Location> locationsByKeyId = new HashMap();
    @Nonnull
    private final Stack<Location> defaultLocations = new Stack();
    @Nonnull
    private CodecContext context = new CodecContext();
    private boolean strict = false;
    @CheckForNull
    private String name;

    public AsapConfigBuilder(boolean debug, @Nonnull ReflectionManager reflectionManager) {
        this.defaultLocations.push(NO_LOCATION);
        this.loadProperties(reflectionManager, debug);
    }

    public AsapConfigBuilder(boolean debug) {
        this.defaultLocations.push(NO_LOCATION);
        this.loadProperties(ReflectionFactory.getManager(), debug);
    }

    private void loadProperties(@Nonnull ReflectionManager reflectionManager, boolean debug) {
        Set<ReflectionManager.ClassWithLocation<?>> classesWithIds = reflectionManager.getAnnotatedByWithLocation(HasKeyId.class);
        boolean hasErrors = false;
        for (ReflectionManager.ClassWithLocation<?> propertyIdElement : classesWithIds) {
            Field[] fields;
            Class<?> propertyIdClass = propertyIdElement.getClazz();
            for (Field field : fields = propertyIdClass.getDeclaredFields()) {
                if (!KeyId.class.isAssignableFrom(field.getType())) continue;
                if ((field.getModifiers() & 8) == 0) {
                    logger.log(Level.WARNING, "Key id ''{0}'' should be declared static in ''{1}''", new Object[]{field.getName(), propertyIdClass.getName()});
                    continue;
                }
                if ((field.getModifiers() & 0x10) == 0) {
                    hasErrors = true;
                    logger.log(Level.SEVERE, "Key id ''{0}'' must be declared final in ''{1}''", new Object[]{field.getName(), propertyIdClass.getName()});
                }
                try {
                    Location location;
                    field.setAccessible(true);
                    KeyId keyId = (KeyId)field.get(null);
                    if (this.keyIdsByName.containsKey(keyId.getName())) {
                        hasErrors = true;
                        location = this.locationsByKeyId.get(keyId);
                        if (location != null) {
                            logger.log(Level.SEVERE, "A Key id named ''{0}'' already exists in {1}", new Object[]{keyId.getName(), this.locationsByKeyId.get(keyId).getDescription()});
                        } else {
                            logger.log(Level.SEVERE, "A Key id named ''{0}'' already exists", keyId.getName());
                        }
                    }
                    this.defaultLocationsByKeyId.put(keyId, new FieldLocation(field));
                    this.keyIdsByName.put(keyId.getName(), keyId);
                    location = null;
                    if (debug) {
                        location = new FieldLocation(field);
                    }
                    if (!propertyIdElement.getLocation().equals(NoLocation.getInstance())) {
                        location = location != null ? new ContainerLocation(propertyIdElement.getLocation(), location) : propertyIdElement.getLocation();
                    }
                    if (location == null) continue;
                    this.locationsByKeyId.put(keyId, location);
                }
                catch (IllegalArgumentException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        if (hasErrors) {
            throw new ExceptionInInitializerError(new ConfigurationError("Problem on property declarations (see log)"));
        }
    }

    @Nonnull
    public AsapConfigBuilder load(@Nonnull InputStream is, @Nonnull Location location) throws IOException, ConfigurationException {
        ChainedException.ChainedExceptionBuilder<ConfigurationException> exceptions = new ChainedException.ChainedExceptionBuilder<ConfigurationException>();
        LineNumberReader br = new LineNumberReader(new InputStreamReader(is));
        String line = br.readLine();
        while (line != null) {
            if (line.length() > 0 && line.charAt(0) != '#' && !CharMatcher.WHITESPACE.matchesAllOf(line)) {
                int indexOfEqual = line.indexOf(61);
                if (indexOfEqual == -1) {
                    exceptions.appendException(new FormatConfigurationException(new ColumnAndLineLocation(location, br.getLineNumber())));
                } else {
                    String propertyName = line.substring(0, indexOfEqual).trim();
                    String propertyValue = line.substring(indexOfEqual + 1, line.length()).trim();
                    try {
                        this.set(propertyName, propertyValue, (Location)new ColumnAndLineLocation(location, br.getLineNumber()));
                    }
                    catch (ConfigurationException e) {
                        exceptions.appendException(e);
                    }
                }
            }
            line = br.readLine();
        }
        exceptions.throwIfNecessary();
        return this;
    }

    @Nonnull
    public AsapConfigBuilder setString(@Nonnull String name, @Nonnull String value, @Nonnull Location location) throws UnknownPropertyNameException, PropertyIdException {
        KeyId<?, ?> keyId = this.keyIdsByName.get(name);
        if (keyId == null || !(keyId instanceof PropertyId)) {
            throw new UnknownPropertyNameException(name);
        }
        try {
            this.setString((PropertyId)keyId, value, location);
        }
        catch (UnknownPropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public <T> AsapConfigBuilder set(@Nonnull String name, @Nonnull T value, @Nonnull Location location) throws UnknownPropertyNameException, PropertyIdException {
        KeyId<?, ?> keyId = this.keyIdsByName.get(name);
        if (keyId == null || !(keyId instanceof PropertyId)) {
            throw new UnknownPropertyNameException(name);
        }
        PropertyId propertyId = (PropertyId)keyId;
        if (this.context.isDebug()) {
            try {
                propertyId.getCodec().checkValue(this.context, value);
            }
            catch (Exception e) {
                throw new ConfigurationError("Property '" + name + "': " + e.getMessage());
            }
        }
        try {
            this.set(propertyId, value, location);
        }
        catch (UnknownPropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder setString(@Nonnull PropertyId<?> propertyId, @Nonnull String value, @Nonnull Location location) throws PropertyIdException {
        if (!this.keyIdsByName.values().contains(propertyId)) {
            throw new UnknownPropertyIdException(propertyId);
        }
        if (this.strict) {
            try {
                propertyId.getCodec().checkString(this.context, value);
            }
            catch (ParsingException e) {
                throw new PropertyIdException(propertyId, location, e);
            }
        }
        PropertyId<?> propertyId2 = propertyId;
        propertyId2.getClass();
        this.valuesById.put(propertyId, new PropertyId.Value(propertyId2, value));
        this.valueLocationsByKeyId.put(propertyId, location);
        return this;
    }

    @Nonnull
    public <T> AsapConfigBuilder set(@Nonnull PropertyId<T> propertyId, @Nonnull T value, @Nonnull Location location) throws PropertyIdException {
        if (!this.keyIdsByName.values().contains(propertyId)) {
            throw new UnknownPropertyIdException(propertyId);
        }
        if (this.context.isDebug()) {
            try {
                propertyId.getCodec().checkValue(this.context, value);
            }
            catch (Exception e) {
                throw new ConfigurationError("Property '" + propertyId.getName() + "': " + e.getMessage());
            }
        }
        PropertyId<T> propertyId2 = propertyId;
        propertyId2.getClass();
        this.valuesById.put(propertyId, new PropertyId.Value(propertyId2, this.context, value));
        this.valueLocationsByKeyId.put(propertyId, location);
        return this;
    }

    @Nonnull
    public <T> AsapConfigBuilder set(@Nonnull ObjectId<T> objectId, @Nonnull T value, @Nonnull Location location) {
        this.instances.put(objectId, value);
        this.valueLocationsByKeyId.put(objectId, location);
        return this;
    }

    @Nonnull
    public AsapConfigBuilder setStrictMode() {
        this.strict = true;
        return this;
    }

    @Nonnull
    public AsapConfigBuilder setName(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public CodecContext getCodecContext() {
        return this.context;
    }

    @Nonnull
    public AsapConfigBuilder setCodecContext(@Nonnull CodecContext context) {
        this.context = context;
        return this;
    }

    @Nonnull
    public AsapConfigBuilder setHooks(@Nonnull RunnableHooks hooks) {
        this.context.setHooks(hooks);
        return this;
    }

    @Nonnull
    public <X> Config build() throws ConfigurationException {
        ChainedException.ChainedExceptionBuilder<ConfigurationException> exceptions = new ChainedException.ChainedExceptionBuilder<ConfigurationException>();
        if (this.context.isDebug()) {
            logger.setLevel(Level.FINE);
        } else {
            logger.setLevel(Level.INFO);
        }
        HashMap values = new HashMap();
        this.processValues(values);
        this.processDefaultValues(values);
        ConfigChecker checker = new ConfigChecker(this.context, values, this.instances, this.valueLocationsByKeyId);
        for (KeyId<?, ?> keyId : this.keyIdsByName.values()) {
            boolean needChecks = false;
            try {
                needChecks = keyId.isRequired(checker);
                if (!needChecks) {
                    BooleanExpression expression = keyId.getRequiredExpression();
                    assert (expression != null);
                    checker.remove(keyId, expression.getCause(checker));
                }
            }
            catch (ConfigurationException expression) {
                // empty catch block
            }
            if (!needChecks) continue;
            try {
                checker.check(keyId);
            }
            catch (ConfigurationException e) {
                BooleanExpression expression = keyId.getRequiredExpression();
                if (expression != null) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        sb.append(" (required because ");
                        sb.append(expression.getCause(checker));
                        sb.append(')');
                        String detailed = sb.toString();
                        for (ChainedException all : e) {
                            e.setMessage(e.getMessage() + detailed);
                        }
                    }
                    catch (PropertyIdException propertyIdException) {
                        // empty catch block
                    }
                }
                exceptions.appendException(e);
            }
        }
        exceptions.throwIfNecessary();
        ConfigImpl config = this.context.isDebug() ? new ConfigDebug(this.context, checker.getValues(), checker.getInstances(), checker.getDropCauses()) : new ConfigImpl(this.context, checker.getValues(), checker.getInstances());
        if (this.name != null) {
            config.setName(this.name);
        }
        return config;
    }

    @Nonnull
    public Collection<PropertyId<?>> getPropertyIds() {
        return this.getPropertyIds(Category.class);
    }

    @Nonnull
    public Collection<PropertyId<?>> getPropertyIds(@Nonnull Class<? extends Category> category) {
        ArrayList result = new ArrayList(this.keyIdsByName.size());
        for (KeyId<?, ?> keyId : this.keyIdsByName.values()) {
            PropertyId propertyId;
            if (!(keyId instanceof PropertyId) || (propertyId = (PropertyId)keyId).hasCategory(Private.class) || !propertyId.hasCategory(category)) continue;
            result.add(propertyId);
        }
        return result;
    }

    @CheckForNull
    public <T> String getDefaultValue(@Nonnull PropertyId<T> propertyId) {
        PropertyId.Value value = propertyId.getDefaultValue(this.context);
        if (value != null) {
            return value.getString();
        }
        return null;
    }

    @Nonnull
    public Location getLocation(@Nonnull KeyId<?, ?> keyId) {
        Location location = this.locationsByKeyId.get(keyId);
        return location == null ? NoLocation.getInstance() : location;
    }

    private void processValues(@Nonnull Map<PropertyId<?>, PropertyId.Value> values) {
        values.putAll(this.valuesById);
    }

    private void processDefaultValues(@Nonnull Map<PropertyId<?>, PropertyId.Value> values) {
        for (KeyId<?, ?> keyId : this.keyIdsByName.values()) {
            if (!(keyId instanceof PropertyId)) continue;
            PropertyId propertyId = (PropertyId)keyId;
            if (values.containsKey(keyId)) continue;
            PropertyId.Value defaultValue = propertyId.getDefaultValue(this.context);
            values.put(propertyId, defaultValue != null ? defaultValue.duplicate() : null);
            this.valueLocationsByKeyId.put(keyId, this.defaultLocationsByKeyId.get(keyId));
        }
    }

    public AsapConfigBuilder processEnvironmentVariables(@Nonnull String envPrefix) throws ConfigurationException {
        ChainedException.ChainedExceptionBuilder<ConfigurationException> exceptions = new ChainedException.ChainedExceptionBuilder<ConfigurationException>();
        for (Map.Entry<String, String> envKeyValue : System.getenv().entrySet()) {
            String envKey = envKeyValue.getKey();
            if (!envKey.startsWith(envPrefix)) continue;
            PropertyId propertyId = null;
            int numMatches = 0;
            String variable = envKey.substring(envPrefix.length());
            for (Map.Entry<String, KeyId<?, ?>> entry : this.keyIdsByName.entrySet()) {
                String keyIdName = entry.getKey();
                String value = envKeyValue.getValue();
                if (!keyIdName.equalsIgnoreCase(variable) && !keyIdName.replace('.', '_').replace('-', '_').equalsIgnoreCase(variable)) continue;
                if (entry.getValue() instanceof PropertyId) {
                    PropertyId previousPropertyId = propertyId;
                    propertyId = (PropertyId)entry.getValue();
                    if (++numMatches == 2) {
                        exceptions.appendException(new VariableMatchesSeveralConfigurationException(envKey, previousPropertyId));
                    }
                    if (numMatches >= 2) {
                        assert (propertyId != null);
                        exceptions.appendException(new VariableMatchesSeveralConfigurationException(envKey, propertyId));
                    }
                    logger.log(Level.WARNING, "Property ''{0}'' is overridden by environment variable ''{1}'' with ''{2}''", new Object[]{keyIdName, envKey, value});
                    try {
                        assert (propertyId != null);
                        this.setString(propertyId, value, (Location)new EnvironmentLocation(envKey));
                    }
                    catch (ConfigurationException e) {
                        exceptions.appendException(e);
                    }
                    continue;
                }
                logger.log(Level.SEVERE, "Environment variable ''{0}'' try to overridde an object-id ''{1}'' with ''{2}''", new Object[]{envKey, keyIdName, value});
            }
            if (numMatches != 0) continue;
            exceptions.appendException(new VariableDoesNotMatchConfigurationException(envKey));
        }
        exceptions.throwIfNecessary();
        return this;
    }

    public void pushDefaultLocation(@Nonnull Location location) {
        this.defaultLocations.push(location);
    }

    public void popDefaultLocation() {
        assert (this.defaultLocations.size() > 1);
        this.defaultLocations.pop();
    }

    @Nonnull
    public <T> AsapConfigBuilder set(@Nonnull ObjectId<T> objectId, @Nonnull T value) {
        return this.set(objectId, value, this.defaultLocations.peek());
    }

    @Nonnull
    public <T> AsapConfigBuilder set(@Nonnull String name, @Nonnull T value) throws UnknownPropertyNameException, PropertyIdException {
        return this.set(name, value, this.defaultLocations.peek());
    }

    @Nonnull
    public <T> AsapConfigBuilder set(@Nonnull PropertyId<T> propertyId, @Nonnull T value) throws PropertyIdException {
        return this.set(propertyId, value, this.defaultLocations.peek());
    }

    @Nonnull
    public AsapConfigBuilder setString(@Nonnull PropertyId<?> propertyId, @Nonnull String value) throws PropertyIdException {
        return this.setString(propertyId, value, this.defaultLocations.peek());
    }

    @Nonnull
    public AsapConfigBuilder setString(@Nonnull String name, @Nonnull String value) throws UnknownPropertyNameException, PropertyIdException {
        return this.setString(name, value, this.defaultLocations.peek());
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Boolean> propertyId, boolean value) {
        try {
            this.set((PropertyId)propertyId, (Object)value);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Boolean> propertyId, boolean value, @Nonnull Location location) {
        try {
            this.set((PropertyId)propertyId, (Object)value, location);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Byte> propertyId, byte value) {
        try {
            this.set((PropertyId)propertyId, (Object)value);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Byte> propertyId, byte value, @Nonnull Location location) {
        try {
            this.set((PropertyId)propertyId, (Object)value, location);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Short> propertyId, short value) {
        try {
            this.set((PropertyId)propertyId, (Object)value);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Short> propertyId, short value, @Nonnull Location location) {
        try {
            this.set((PropertyId)propertyId, (Object)value, location);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Character> propertyId, char value) {
        try {
            this.set((PropertyId)propertyId, (Object)Character.valueOf(value));
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Character> propertyId, char value, @Nonnull Location location) {
        try {
            this.set((PropertyId)propertyId, (Object)Character.valueOf(value), location);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Integer> propertyId, int value) {
        try {
            this.set((PropertyId)propertyId, (Object)value);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Integer> propertyId, int value, @Nonnull Location location) {
        try {
            this.set((PropertyId)propertyId, (Object)value, location);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Long> propertyId, long value) {
        try {
            this.set((PropertyId)propertyId, (Object)value);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Long> propertyId, long value, @Nonnull Location location) {
        try {
            this.set((PropertyId)propertyId, (Object)value, location);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Float> propertyId, float value) {
        try {
            this.set((PropertyId)propertyId, (Object)Float.valueOf(value));
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Float> propertyId, float value, @Nonnull Location location) {
        try {
            this.set((PropertyId)propertyId, (Object)Float.valueOf(value), location);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Double> propertyId, double value) {
        try {
            this.set((PropertyId)propertyId, (Object)value);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public AsapConfigBuilder set(@Nonnull PropertyId<Double> propertyId, double value, @Nonnull Location location) {
        try {
            this.set((PropertyId)propertyId, (Object)value, location);
        }
        catch (PropertyIdException e) {
            throw new AssertionError();
        }
        return this;
    }
}

