/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileOrDirCodec;
import com.android.sched.util.codec.MessageDigestCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.VFSCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.MessageDigestFactory;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.OutputZipFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.vfs.ReadWriteZipFS;
import com.android.sched.vfs.VFS;
import java.security.Provider;

public class ZipFSCodec
extends FileOrDirCodec<VFS>
implements VFSCodec {
    @Nonnull
    private final MessageDigestCodec messageDigestCodec = new MessageDigestCodec();
    @Nonnull
    private final OutputZipFile.Compression compression;
    @CheckForNull
    private String infoString;

    public ZipFSCodec(@Nonnull FileOrDirectory.Existence existence, @Nonnull OutputZipFile.Compression compression) {
        super(existence, 3);
        this.compression = compression;
    }

    @Nonnull
    public ZipFSCodec changeOwnerPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.OWNER);
        return this;
    }

    @Nonnull
    public ZipFSCodec changeAllPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.EVERYBODY);
        return this;
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull VFS dir) {
    }

    @Override
    @Nonnull
    public VFS parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull VFS directory) {
        return directory.getPath();
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a zip archive (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "zip";
    }

    @Override
    @Nonnull
    public VFS checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        RunnableHooks hooks = context.getRunnableHooks();
        try {
            Provider.Service service = (Provider.Service)this.messageDigestCodec.checkString(context, "SHA");
            ReadWriteZipFS rwzFS = new ReadWriteZipFS(new OutputZipFile(context.getWorkingDirectory(), string, hooks, this.existence, this.change, this.compression), 1, 2, new MessageDigestFactory(service), false);
            rwzFS.setInfoString(this.infoString);
            return rwzFS;
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotDirectoryException | NotFileException | WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    @Nonnull
    public ZipFSCodec setInfoString(@CheckForNull String infoString) {
        this.infoString = infoString;
        return this;
    }
}

