/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CharsetCodec;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.ReaderFile;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.StandardInputLocation;
import java.nio.charset.Charset;

public class ReaderFileCodec
extends FileCodec<ReaderFile> {
    @Nonnegative
    private int bufferSize = 8192;
    @Nonnull
    private static final Location STANDARD_INPUT_LOCATION = new StandardInputLocation();

    public ReaderFileCodec() {
        super(FileOrDirectory.Existence.MUST_EXIST, 1);
    }

    @Nonnull
    public ReaderFileCodec allowStandardInput() {
        this.allowStandardIO = true;
        return this;
    }

    @Nonnull
    public ReaderFileCodec allowCharset() {
        this.charsetCodec = new CharsetCodec().withMinCharsetToDisplay(5);
        return this;
    }

    @Nonnull
    public ReaderFileCodec allowCharset(@Nonnull CharsetCodec codec) {
        this.charsetCodec = codec;
        return this;
    }

    @Nonnull
    public ReaderFileCodec withDefaultCharset(@Nonnull Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
        return this;
    }

    @Nonnull
    public ReaderFileCodec withBuffer(@Nonnegative int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull ReaderFile reader) {
        String string = reader.isStandard() ? "-" : reader.getPath();
        if (this.charsetCodec != null) {
            string = string + "[" + reader.getCharset().displayName() + "]";
        }
        return string;
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull ReaderFile reader) throws CheckingException {
        if (reader.isStandard() && !this.allowStandardIO) {
            throw new CheckingException("Standard input is not allowed");
        }
    }

    @Override
    @Nonnull
    public ReaderFile parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public ReaderFile checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        Charset localCharset = this.parseCharset(context, string);
        if (localCharset != null) {
            string = string.substring(0, string.lastIndexOf(91));
        }
        if (string.equals("-")) {
            if (!this.allowStandardIO) {
                throw new ParsingException("Standard input can not be used");
            }
            return new ReaderFile(context.getStandardInput(), this.getCharset(context, localCharset), this.bufferSize, STANDARD_INPUT_LOCATION);
        }
        try {
            return new ReaderFile(context.getWorkingDirectory(), string, this.getCharset(context, localCharset), this.bufferSize);
        }
        catch (NoSuchFileException | NotFileException | WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }
}

