/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ChainedException;
import com.android.sched.util.config.ConfigurationError;
import java.util.ArrayList;
import java.util.List;

public class PairCodec<T, U>
implements StringCodec<Pair<T, U>> {
    @Nonnull
    private final StringCodec<T> keyParser;
    @Nonnull
    private final StringCodec<U> valueParser;
    @Nonnull
    private String separator = "=";

    public PairCodec(@Nonnull StringCodec<T> keyParser, @Nonnull StringCodec<U> valueParser) {
        this.keyParser = keyParser;
        this.valueParser = valueParser;
    }

    @Nonnull
    public PairCodec<T, U> on(@Nonnull String separator) {
        this.separator = separator;
        return this;
    }

    @Nonnull
    public String getSeparator() {
        return this.separator;
    }

    @Override
    @Nonnull
    public Pair<T, U> parseString(@Nonnull CodecContext context, @Nonnull String string) {
        int endKey = string.indexOf(this.separator);
        if (endKey == -1) {
            throw new ConfigurationError("Missing '" + this.separator + "' in '" + string + "'");
        }
        String key = string.substring(0, endKey);
        String valueString = string.substring(endKey + this.separator.length());
        return new Pair(this.keyParser.parseString(context, key), this.valueParser.parseString(context, valueString));
    }

    @Override
    @CheckForNull
    public Pair<T, U> checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        ChainedException.ChainedExceptionBuilder<ParsingException> exceptions = new ChainedException.ChainedExceptionBuilder<ParsingException>();
        Object keyElement = null;
        Object valueElement = null;
        String key = null;
        String valueString = null;
        int endKey = string.indexOf(this.separator);
        if (endKey == -1) {
            exceptions.appendException(new ParsingException("Missing '" + this.separator + "' in '" + string + "'"));
        } else {
            key = string.substring(0, endKey);
            valueString = string.substring(endKey + this.separator.length());
            try {
                keyElement = this.keyParser.checkString(context, key);
            }
            catch (ParsingException e) {
                exceptions.appendException(e);
            }
            try {
                valueElement = this.valueParser.checkString(context, valueString);
            }
            catch (ParsingException e) {
                exceptions.appendException(e);
            }
        }
        exceptions.throwIfNecessary();
        if (keyElement == null && valueElement == null) {
            return null;
        }
        if (keyElement == null) {
            assert (key != null);
            keyElement = this.keyParser.parseString(context, key);
        }
        if (valueElement == null) {
            assert (valueString != null);
            valueElement = this.valueParser.parseString(context, valueString);
        }
        return new Pair<Object, Object>(keyElement, valueElement);
    }

    @Override
    @Nonnull
    public String getUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        sb.append(this.keyParser.getVariableName());
        sb.append('>');
        sb.append(this.separator);
        sb.append('<');
        sb.append(this.valueParser.getVariableName());
        sb.append("> where <");
        sb.append(this.keyParser.getVariableName());
        sb.append("> is ");
        sb.append(this.keyParser.getUsage());
        sb.append(" and where <");
        sb.append(this.valueParser.getVariableName());
        sb.append("> is ");
        sb.append(this.valueParser.getUsage());
        return sb.toString();
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "pair";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        ArrayList<Parser.ValueDescription> list = new ArrayList<Parser.ValueDescription>();
        list.addAll(this.keyParser.getValueDescriptions());
        list.addAll(this.valueParser.getValueDescriptions());
        return list;
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull Pair<T, U> data) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.keyParser.formatValue(data.getFirst()));
        sb.append(this.separator);
        sb.append(this.valueParser.formatValue(data.getSecond()));
        return sb.toString();
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull Pair<T, U> data) throws CheckingException {
        ChainedException.ChainedExceptionBuilder<CheckingException> exceptions = new ChainedException.ChainedExceptionBuilder<CheckingException>();
        try {
            this.keyParser.checkValue(context, data.getFirst());
        }
        catch (CheckingException e) {
            exceptions.appendException(e);
        }
        try {
            this.valueParser.checkValue(context, data.getSecond());
        }
        catch (CheckingException e) {
            exceptions.appendException(e);
        }
        exceptions.throwIfNecessary();
    }

    public static class Pair<T, U> {
        @Nonnull
        private final T first;
        @Nonnull
        private final U second;

        public Pair(@Nonnull T first, @Nonnull U second) {
            this.first = first;
            this.second = second;
        }

        @Nonnull
        public T getFirst() {
            return this.first;
        }

        @Nonnull
        public U getSecond() {
            return this.second;
        }

        public final boolean equals(@CheckForNull Object obj) {
            if (obj instanceof Pair) {
                return this.first.equals(((Pair)obj).first) && this.second.equals(((Pair)obj).second);
            }
            return super.equals(obj);
        }

        public final int hashCode() {
            return this.first.hashCode() ^ this.second.hashCode();
        }
    }
}

