/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.OutputStreamFile;
import com.android.sched.util.file.StandardOutputKind;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;

public class OutputStreamCodec
extends FileCodec<OutputStreamFile> {
    private boolean append = false;

    public OutputStreamCodec(@Nonnull FileOrDirectory.Existence existence) {
        super(existence, 2);
    }

    @Nonnull
    public OutputStreamCodec changeOwnerPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.OWNER);
        return this;
    }

    @Nonnull
    public OutputStreamCodec changeAllPermission() {
        this.setChangePermission(FileOrDirectory.ChangePermission.EVERYBODY);
        return this;
    }

    @Nonnull
    public OutputStreamCodec allowStandardOutputOrError() {
        this.allowStandardIO = true;
        this.allowStandardError = true;
        return this;
    }

    @Nonnull
    public OutputStreamCodec allowStandardOutput() {
        this.allowStandardIO = true;
        return this;
    }

    @Nonnull
    public OutputStreamCodec allowStandardError() {
        this.allowStandardError = true;
        return this;
    }

    @Nonnull
    public OutputStreamCodec makeAppendable() {
        this.append = true;
        return this;
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull OutputStreamFile stream) {
        if (stream.isStandard()) {
            if (stream.getLocation().equals(StandardOutputKind.STANDARD_OUTPUT.getLocation())) {
                return "-";
            }
            assert (stream.getLocation().equals(StandardOutputKind.STANDARD_ERROR.getLocation()));
            return "--";
        }
        return stream.getPath();
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull OutputStreamFile stream) throws CheckingException {
        Location location = stream.getLocation();
        if (location.equals(StandardOutputKind.STANDARD_OUTPUT.getLocation()) && !this.allowStandardIO) {
            throw new CheckingException("Standard output is not allowed");
        }
        if (location.equals(StandardOutputKind.STANDARD_ERROR.getLocation()) && !this.allowStandardError) {
            throw new CheckingException("Standard error is not allowed");
        }
    }

    @Override
    @Nonnull
    public OutputStreamFile parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public OutputStreamFile checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        if (string.equals("-")) {
            if (!this.allowStandardIO) {
                throw new ParsingException("Standard output can not be used");
            }
            return new OutputStreamFile(context.getStandardOutput(), StandardOutputKind.STANDARD_OUTPUT.getLocation());
        }
        if (string.equals("--")) {
            if (!this.allowStandardError) {
                throw new ParsingException("Standard error can not be used");
            }
            return new OutputStreamFile(context.getStandardError(), StandardOutputKind.STANDARD_ERROR.getLocation());
        }
        try {
            return new OutputStreamFile(context.getWorkingDirectory(), string, context.getRunnableHooks(), this.existence, this.change, this.append);
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotFileException | WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }
}

