/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileOrDirCodec;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.InputJarFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.NotJarFileException;
import com.android.sched.util.file.WrongPermissionException;
import java.util.Collections;
import java.util.List;

public class InputJarCodec
extends FileOrDirCodec<InputJarFile> {
    public InputJarCodec() {
        super(FileOrDirectory.Existence.MUST_EXIST, 1);
    }

    @Override
    @Nonnull
    public InputJarFile parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public InputJarFile checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            return new InputJarFile(context.getWorkingDirectory(), string);
        }
        catch (NoSuchFileException | NotFileException | NotJarFileException | WrongPermissionException e) {
            throw new ParsingException(e);
        }
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a jar file (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "jar";
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull InputJarFile data) {
        return data.getPath();
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull InputJarFile data) {
    }
}

