/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.FileOrDirCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.file.CannotChangePermissionException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.Directory;
import com.android.sched.util.file.FileAlreadyExistsException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.InputStreamFile;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.StringLocation;
import java.io.File;

public class InputFileOrDirectoryCodec
extends FileOrDirCodec<FileOrDirectory> {
    public InputFileOrDirectoryCodec() {
        super(FileOrDirectory.Existence.MUST_EXIST, 1);
    }

    @Override
    @Nonnull
    public FileOrDirectory parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public FileOrDirectory checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        try {
            Directory workingDir = context.getWorkingDirectory();
            File file = FileOrDirectory.getFileFromWorkingDirectory(workingDir, string);
            if (!file.exists()) {
                throw new ParsingException(new NoSuchFileException(new StringLocation(string)));
            }
            if (file.isFile()) {
                return new InputStreamFile(workingDir, string);
            }
            return new Directory(workingDir, string, context.getRunnableHooks(), this.existence, this.permissions, this.change);
        }
        catch (CannotChangePermissionException | CannotCreateFileException | FileAlreadyExistsException | NoSuchFileException | NotDirectoryException | NotFileException | WrongPermissionException e) {
            throw new ParsingException(e.getMessage(), e);
        }
    }

    @Override
    @Nonnull
    public String getUsage() {
        return "a path to a file or directory (" + this.getDetailedUsage() + ")";
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return "file-or-dir";
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull FileOrDirectory data) {
        return data.getPath();
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull FileOrDirectory data) {
    }
}

