/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.SubReleaseKind;
import com.android.sched.util.UncomparableVersion;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class Version {
    @Nonnegative
    private static final int VERSION_CODE = 2;
    @Nonnull
    private static final String VERSION_CODE_KEY = "version-file.version.code";
    @Nonnull
    private static final String VERSION_KEY = "version";
    @Nonnull
    private static final String RELEASE_NAME_KEY = "version.release.name";
    @Nonnull
    private static final String RELEASE_CODE_KEY = "version.release.code";
    @Nonnull
    private static final String SUB_RELEASE_CODE_KEY = "version.sub-release.code";
    @Nonnull
    private static final String SUB_RELEASE_KIND_KEY = "version.sub-release.kind";
    @Nonnull
    private static final String BUILD_ID_KEY = "version.buildid";
    @Nonnull
    private static final String SHA_KEY = "version.sha";
    @Nonnull
    private static final String RELEASER_KEY = "releaser";
    @Nonnull
    private static final String FILE_SUFFIX = "-version.properties";
    @Nonnull
    private String version;
    @Nonnull
    private String releaseName;
    private int releaseCode;
    @Nonnull
    private SubReleaseKind subReleaseKind;
    private int subReleaseCode;
    @CheckForNull
    private String buildId;
    @CheckForNull
    private String codeBase;
    @CheckForNull
    private String releaser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public Version(@Nonnull String name, @Nonnull ClassLoader loader) throws IOException {
        String resourceName = name + FILE_SUFFIX;
        InputStream resourceStream = loader.getResourceAsStream(resourceName);
        if (resourceStream == null) {
            throw new FileNotFoundException(resourceName);
        }
        try {
            this.initWithInputStream(resourceStream);
        }
        finally {
            try {
                resourceStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public Version(@Nonnull InputStream is) throws IOException {
        this.initWithInputStream(is);
    }

    private void initWithInputStream(@Nonnull InputStream is) throws IOException {
        Properties prop = new Properties();
        prop.load(is);
        long versionFileVersion = Long.parseLong(prop.getProperty(VERSION_CODE_KEY));
        assert (versionFileVersion >= 1L);
        this.version = prop.getProperty(VERSION_KEY);
        assert (this.version != null);
        this.releaseName = prop.getProperty(RELEASE_NAME_KEY);
        assert (this.releaseName != null);
        this.releaseCode = Integer.parseInt(prop.getProperty(RELEASE_CODE_KEY));
        this.subReleaseCode = Integer.parseInt(prop.getProperty(SUB_RELEASE_CODE_KEY));
        this.subReleaseKind = SubReleaseKind.valueOf(SubReleaseKind.class, prop.getProperty(SUB_RELEASE_KIND_KEY));
        this.buildId = prop.getProperty(BUILD_ID_KEY);
        this.codeBase = prop.getProperty(SHA_KEY);
        this.releaser = prop.getProperty(RELEASER_KEY);
        if (versionFileVersion < 2L) {
            this.adaptFromLegacy();
        } else {
            this.ensureValidity();
        }
    }

    public Version(@Nonnull String name, @Nonnull String version, int releaseCode, int subReleaseCode, @Nonnull SubReleaseKind subReleaseKind) {
        this(name, version, releaseCode, subReleaseCode, subReleaseKind, null, null, null);
    }

    public Version(@Nonnull String name, @Nonnull String version, int releaseCode, int subReleaseCode, @Nonnull SubReleaseKind subReleaseKind, @CheckForNull String releaser, @CheckForNull String buildId, @CheckForNull String codeBase) {
        this.version = version;
        this.releaseName = name;
        this.releaser = releaser;
        this.releaseCode = releaseCode;
        this.subReleaseCode = subReleaseCode;
        this.subReleaseKind = subReleaseKind;
        this.buildId = buildId;
        this.codeBase = codeBase;
        this.ensureValidity();
    }

    private void adaptFromLegacy() {
        if (this.buildId != null && this.buildId.isEmpty()) {
            this.buildId = null;
        }
        if (this.codeBase != null && this.codeBase.isEmpty()) {
            this.codeBase = null;
        }
        this.releaser = this.codeBase == null && this.buildId == null ? null : "<unknown>";
        if (this.subReleaseCode == 0 || this.codeBase == null || this.buildId == null || this.subReleaseKind == SubReleaseKind.ENGINEERING) {
            this.subReleaseKind = SubReleaseKind.ENGINEERING;
            this.subReleaseCode = 0;
            int idx = this.version.lastIndexOf(45);
            if (idx >= 0) {
                this.version = this.version.substring(0, idx);
            }
            this.releaser = null;
        }
    }

    private void ensureValidity() {
        if (this.releaser != null && this.releaser.isEmpty()) {
            this.releaser = null;
        }
        if (this.releaser != null) {
            if (this.buildId != null && this.buildId.isEmpty()) {
                this.buildId = null;
            }
            if (this.codeBase != null && this.codeBase.isEmpty()) {
                this.codeBase = null;
            }
            if (this.codeBase == null && this.buildId == null) {
                this.releaser = null;
            }
        } else {
            this.buildId = null;
            this.codeBase = null;
        }
        if (this.subReleaseCode == 0 || this.codeBase == null || this.buildId == null || this.releaser == null || this.subReleaseKind == SubReleaseKind.ENGINEERING) {
            this.subReleaseKind = SubReleaseKind.ENGINEERING;
            this.subReleaseCode = 0;
        }
    }

    @Nonnull
    public String getVersion() {
        return this.version + (this.subReleaseKind == SubReleaseKind.ENGINEERING ? "-eng" : "");
    }

    @Nonnull
    public String getReleaseName() {
        return this.releaseName;
    }

    public int getReleaseCode() {
        return this.releaseCode;
    }

    @Nonnull
    public SubReleaseKind getSubReleaseKind() {
        return this.subReleaseKind;
    }

    public int getSubReleaseCode() {
        return this.subReleaseCode;
    }

    @CheckForNull
    public String getBuildId() {
        return this.buildId;
    }

    @CheckForNull
    public String getCodeBase() {
        return this.codeBase;
    }

    @CheckForNull
    public String getReleaser() {
        return this.releaser;
    }

    @Nonnull
    public String getVerboseVersion() {
        String str = this.getVersion() + " '" + this.releaseName + "'";
        if (this.releaser != null) {
            str = str + " (";
            if (this.buildId != null) {
                str = str + this.buildId;
                if (this.codeBase != null) {
                    str = str + " ";
                }
            }
            if (this.codeBase != null) {
                str = str + this.codeBase;
            }
            str = str + " by " + this.releaser + ')';
        }
        return str;
    }

    public boolean isOlderThan(@Nonnull Version other) throws UncomparableVersion {
        return this.compareTo(other) < 0;
    }

    public boolean isOlderThan(int releaseCode, int subReleaseCode) throws UncomparableVersion {
        return this.compareTo(releaseCode, subReleaseCode) < 0;
    }

    public boolean isOlderOrEqualThan(@Nonnull Version other) throws UncomparableVersion {
        return this.compareTo(other) <= 0;
    }

    public boolean isOlderOrEqualThan(int releaseCode, int subReleaseCode) throws UncomparableVersion {
        return this.compareTo(releaseCode, subReleaseCode) <= 0;
    }

    public boolean isNewerThan(@Nonnull Version other) throws UncomparableVersion {
        return this.compareTo(other) > 0;
    }

    public boolean isNewerThan(int releaseCode, int subReleaseCode) throws UncomparableVersion {
        return this.compareTo(releaseCode, subReleaseCode) > 0;
    }

    public boolean isNewerOrEqualThan(@Nonnull Version other) throws UncomparableVersion {
        return this.compareTo(other) >= 0;
    }

    public boolean isNewerOrEqualThan(int releaseCode, int subReleaseCode) throws UncomparableVersion {
        return this.compareTo(releaseCode, subReleaseCode) >= 0;
    }

    public boolean isSame(@Nonnull Version other) throws UncomparableVersion {
        return this.compareTo(other) == 0;
    }

    public boolean isSame(int releaseCode, int subReleaseCode) throws UncomparableVersion {
        return this.compareTo(releaseCode, subReleaseCode) == 0;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Version) {
            Version other = (Version)obj;
            return this.version.equals(other.version) && this.releaseName.equals(other.releaseName) && this.releaseCode == other.releaseCode && this.subReleaseCode == other.subReleaseCode && this.subReleaseKind == other.subReleaseKind && (this.buildId != null && this.buildId.equals(other.buildId) || this.buildId == null && other.buildId == null) && (this.codeBase != null && this.codeBase.equals(other.codeBase) || this.codeBase == null && other.codeBase == null);
        }
        return false;
    }

    public final int hashCode() {
        return this.version.hashCode() ^ this.releaseName.hashCode() ^ this.releaseCode * 7 ^ this.subReleaseCode * 17 ^ this.subReleaseKind.hashCode() ^ (this.buildId != null ? this.buildId.hashCode() : 0) ^ (this.codeBase != null ? this.codeBase.hashCode() : 0);
    }

    public boolean isComparable() {
        return this.subReleaseKind != SubReleaseKind.ENGINEERING && this.releaseCode > 0 && this.subReleaseCode > 0;
    }

    private boolean isComparable(int releaseCode, int subReleaseCode) {
        return releaseCode > 0 && subReleaseCode > 0;
    }

    int compareTo(int releaseCode, int subReleaseCode) throws UncomparableVersion {
        if (!this.isComparable(releaseCode, subReleaseCode)) {
            throw new UncomparableVersion("Version " + releaseCode + "." + subReleaseCode + " is not comparable");
        }
        if (!this.isComparable()) {
            throw new UncomparableVersion(this.getVerboseVersion() + " is not comparable");
        }
        if (this.releaseCode > releaseCode || this.releaseCode == releaseCode && this.subReleaseCode > subReleaseCode) {
            return 1;
        }
        if (this.releaseCode < releaseCode || this.releaseCode == releaseCode && this.subReleaseCode < subReleaseCode) {
            return -1;
        }
        return 0;
    }

    int compareTo(@Nonnull Version other) throws UncomparableVersion {
        if (!other.isComparable()) {
            throw new UncomparableVersion(this.getVerboseVersion() + " is not comparable");
        }
        return this.compareTo(other.getReleaseCode(), other.getSubReleaseCode());
    }

    @Nonnull
    public String toString() {
        return this.releaseCode + "." + this.subReleaseCode + "-" + (Object)((Object)this.subReleaseKind);
    }

    public void store(@Nonnull OutputStream out) throws IOException {
        Properties prop = new Properties();
        prop.put(VERSION_CODE_KEY, Integer.toString(2));
        prop.put(VERSION_KEY, this.version);
        prop.put(RELEASE_NAME_KEY, this.releaseName);
        prop.put(RELEASE_CODE_KEY, Integer.toString(this.releaseCode));
        prop.put(SUB_RELEASE_CODE_KEY, Integer.toString(this.subReleaseCode));
        prop.put(SUB_RELEASE_KIND_KEY, this.subReleaseKind.toString());
        if (this.buildId != null) {
            prop.put(BUILD_ID_KEY, this.buildId);
        }
        if (this.codeBase != null) {
            prop.put(SHA_KEY, this.codeBase);
        }
        if (this.releaser != null) {
            prop.put(RELEASER_KEY, this.releaser);
        }
        prop.store(out, "Version description");
    }
}

