/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util;

import com.android.jill.google.common.collect.Lists;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.ObjectId;
import com.android.sched.util.log.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@HasKeyId
public class RunnableHooks {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private static final ObjectId<RunnableHooks> SHUTDOWN_HOOKS = new ObjectId<RunnableHooks>("sched.internal.shutdown", RunnableHooks.class);
    @Nonnull
    private final List<Runnable> hooks = new ArrayList<Runnable>();

    public synchronized void addHook(@Nonnull Runnable hook) {
        assert (!this.hooks.contains(hook));
        this.hooks.add(hook);
    }

    public synchronized void removeHook(@Nonnull Runnable hook) {
        assert (this.hooks.contains(hook));
        this.hooks.remove(hook);
    }

    public synchronized void runHooks() {
        Throwable current = null;
        for (Runnable hook : Lists.reverse(this.hooks)) {
            try {
                hook.run();
            }
            catch (Error | RuntimeException e) {
                this.logger.log(Level.SEVERE, "Uncaught exception during RunnableHook", e);
                if (current != null) continue;
                current = e;
            }
        }
        this.hooks.clear();
        if (current != null) {
            if (current instanceof Error) {
                throw (Error)current;
            }
            if (current instanceof RuntimeException) {
                throw (RuntimeException)current;
            }
            throw new AssertionError((Object)current);
        }
    }

    @Nonnull
    public static RunnableHooks getShutdownHooks() {
        return ThreadConfig.get(SHUTDOWN_HOOKS);
    }
}

