/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler.genetic;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.Component;
import com.android.sched.scheduler.GroupPlanCandidate;
import com.android.sched.scheduler.IllegalRequestException;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.PlanError;
import com.android.sched.scheduler.PlanNotFoundException;
import com.android.sched.scheduler.Planner;
import com.android.sched.scheduler.Request;
import com.android.sched.scheduler.TagOrMarkerOrComponentSet;
import com.android.sched.util.log.LoggerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GeneticPlanner<T extends Component>
implements Planner<T> {
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();

    @Override
    @Nonnull
    public Plan<T> buildPlan(@Nonnull Request request, @Nonnull Class<T> rootRunOn) throws PlanNotFoundException, IllegalRequestException {
        GroupPlanCandidate<T> planCandidate = this.buildPlanCandidate(request, rootRunOn);
        if (planCandidate.isValid()) {
            try {
                Plan plan = planCandidate.getPlanBuilder().getPlan();
                return plan;
            }
            catch (PlanError e) {
                throw new AssertionError((Object)"Invalid plan returned by the Genetic Palnner");
            }
        }
        this.logger.log(Level.FINE, "Unsastisfied runners:");
        int idx = 0;
        while ((long)idx < planCandidate.getUnsatisfiedConstraintCount()) {
            int idxRunnable = planCandidate.getIndexFromUnsatisfiedIndex(idx);
            ManagedRunnable runnable = planCandidate.getRunnables().get(idxRunnable);
            TagOrMarkerOrComponentSet tags = planCandidate.getBeforeTags(idxRunnable);
            this.logger.log(Level.FINE, "  #{0}: {1} can not have {2} can not avoid {3}", new Object[]{Integer.toString(idx), runnable, runnable.getMissingTags(request.getFeatures(), tags), runnable.getForbiddenTags(request.getFeatures(), tags)});
            this.logger.log(Level.FINE, "Best candidate plan: {0}", planCandidate.getDetailedDescription());
            ++idx;
        }
        throw new PlanNotFoundException();
    }

    protected abstract GroupPlanCandidate<T> buildPlanCandidate(@Nonnull Request var1, @Nonnull Class<T> var2) throws PlanNotFoundException, IllegalRequestException;
}

