/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler.genetic;

import com.android.jill.google.common.base.Joiner;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.Component;
import com.android.sched.scheduler.FitnessPlanCandidate;
import com.android.sched.scheduler.GroupPlanCandidate;
import com.android.sched.scheduler.Planner;
import com.android.sched.scheduler.Request;
import com.android.sched.scheduler.genetic.AddPostRunnerMutation;
import com.android.sched.scheduler.genetic.AddPreRunnerMutation;
import com.android.sched.scheduler.genetic.AddRunnerMutation;
import com.android.sched.scheduler.genetic.GeneticEventType;
import com.android.sched.scheduler.genetic.GeneticPlanner;
import com.android.sched.scheduler.genetic.MoveRunnerMutation;
import com.android.sched.scheduler.genetic.PlanEvaluator;
import com.android.sched.scheduler.genetic.PlanFactory;
import com.android.sched.scheduler.genetic.RemoveRunnerMutation;
import com.android.sched.scheduler.genetic.RemoveUnsatisfiedRunnerMutation;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.IntegerPropertyId;
import com.android.sched.util.config.id.ProbabilityPropertyId;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.uncommons.maths.number.AdjustableNumberGenerator;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.Probability;
import org.uncommons.maths.random.XORShiftRNG;
import org.uncommons.watchmaker.framework.CachingFitnessEvaluator;
import org.uncommons.watchmaker.framework.EvolutionObserver;
import org.uncommons.watchmaker.framework.EvolutionaryOperator;
import org.uncommons.watchmaker.framework.FitnessEvaluator;
import org.uncommons.watchmaker.framework.GenerationalEvolutionEngine;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.SelectionStrategy;
import org.uncommons.watchmaker.framework.TerminationCondition;
import org.uncommons.watchmaker.framework.operators.EvolutionPipeline;
import org.uncommons.watchmaker.framework.selection.TournamentSelection;
import org.uncommons.watchmaker.framework.termination.ElapsedTime;
import org.uncommons.watchmaker.framework.termination.Stagnation;

@ImplementationName(iface=Planner.class, name="genetic")
@HasKeyId
public class GeneticHardcodedPlanner<T extends Component>
extends GeneticPlanner<T> {
    @Nonnull
    private static final ProbabilityPropertyId ADD_RUNNER = ProbabilityPropertyId.create("sched.genetic.add", "Probability to add a runner").addDefaultValue("0.15");
    @Nonnull
    private static final ProbabilityPropertyId ADD_PRE_RUNNER = ProbabilityPropertyId.create("sched.genetic.add.pre", "Probability to add a runner before another one in order to satisfied it").addDefaultValue("0.90");
    @Nonnull
    private static final ProbabilityPropertyId ADD_POST_RUNNER = ProbabilityPropertyId.create("sched.genetic.add.post", "Probability to add a satisfied runner after a satisfied one").addDefaultValue("0.30");
    @Nonnull
    private static final ProbabilityPropertyId REMOVE_RUNNER = ProbabilityPropertyId.create("sched.genetic.remove", "Probability to remove a runner").addDefaultValue("0.50");
    @Nonnull
    private static final ProbabilityPropertyId REMOVE_UNSATISFIED_RUNNER = ProbabilityPropertyId.create("sched.genetic.remove.unsatisfied", "Probability to remove an unsatisfied runner").addDefaultValue("0.60");
    @Nonnull
    private static final ProbabilityPropertyId MOVE_RUNNER = ProbabilityPropertyId.create("sched.genetic.move.satisfied", "Probability to move a satisfied runner").addDefaultValue("0.60");
    private static final ProbabilityPropertyId SELECTION_PRESSURE = ProbabilityPropertyId.create("sched.genetic.selection.pressure", "Selection pressure").addDefaultValue("0.50").withMin(0.5);
    @Nonnull
    private static final IntegerPropertyId POPULATION_SIZE = IntegerPropertyId.create("sched.genetic.population", "Size of the population").addDefaultValue("10").withMin(1L);
    @Nonnull
    private static final IntegerPropertyId ELITE_COUNT = IntegerPropertyId.create("sched.genetic.elite", "Size of the elite population").addDefaultValue("2").withMin(0L);
    @Nonnull
    private static final IntegerPropertyId STAGNATION = IntegerPropertyId.create("sched.genetic.stagnation", "Number of times a population stagnates before stopping").addDefaultValue("1000").withMin(1L);
    @Nonnull
    private static final IntegerPropertyId MAX_DURATION = IntegerPropertyId.create("sched.genetic.duration", "Maximum time (in milliseconds) to spend before stopping").addDefaultValue("60000").withMin(0L);
    @CheckForNull
    private static Random rng = null;
    @Nonnull
    private final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    @Nonnull
    protected GroupPlanCandidate<T> buildPlanCandidate(@Nonnull Request request, @Nonnull Class<T> rootRunOn) {
        if (rng == null) {
            try (Event event = this.tracer.open(GeneticEventType.RANDOM_INIT);){
                this.logger.log(Level.FINER, "Initializing random generator");
                rng = new XORShiftRNG();
            }
        }
        CachingFitnessEvaluator evaluator = new CachingFitnessEvaluator(new PlanEvaluator());
        PlanFactory<T> factory = new PlanFactory<T>(request, rootRunOn);
        ArrayList<Object> operators = new ArrayList<Object>();
        operators.add(new AddRunnerMutation((NumberGenerator<Probability>)new AdjustableNumberGenerator((Number)new Probability((double)ThreadConfig.get(ADD_RUNNER).floatValue())), request, rootRunOn));
        operators.add(new AddPreRunnerMutation((NumberGenerator<Probability>)new AdjustableNumberGenerator((Number)new Probability((double)ThreadConfig.get(ADD_PRE_RUNNER).floatValue())), request));
        operators.add(new AddPostRunnerMutation((NumberGenerator<Probability>)new AdjustableNumberGenerator((Number)new Probability((double)ThreadConfig.get(ADD_POST_RUNNER).floatValue())), request));
        operators.add(new RemoveRunnerMutation((NumberGenerator<Probability>)new AdjustableNumberGenerator((Number)new Probability((double)ThreadConfig.get(REMOVE_RUNNER).floatValue())), request, rootRunOn));
        operators.add(new RemoveUnsatisfiedRunnerMutation((NumberGenerator<Probability>)new AdjustableNumberGenerator((Number)new Probability((double)ThreadConfig.get(REMOVE_UNSATISFIED_RUNNER).floatValue()))));
        operators.add(new MoveRunnerMutation((NumberGenerator<Probability>)new AdjustableNumberGenerator((Number)new Probability((double)ThreadConfig.get(MOVE_RUNNER).floatValue())), request));
        TournamentSelection selection = new TournamentSelection((NumberGenerator)new AdjustableNumberGenerator((Number)new Probability((double)ThreadConfig.get(SELECTION_PRESSURE).floatValue())));
        GenerationalEvolutionEngine engine = new GenerationalEvolutionEngine(factory, (EvolutionaryOperator)new EvolutionPipeline(operators), (FitnessEvaluator)evaluator, (SelectionStrategy)selection, rng);
        if (this.logger.isLoggable(Level.FINEST)) {
            engine.addEvolutionObserver(new EvolutionObserver<FitnessPlanCandidate<T>>(){

                public void populationUpdate(PopulationData<? extends FitnessPlanCandidate<T>> population) {
                    GeneticHardcodedPlanner.this.logger.log(Level.FINE, "Candidate fitness: {0}, plan: {1}", new Object[]{String.valueOf(population.getBestCandidateFitness()), Joiner.on(", ").join((Iterable)population.getBestCandidate())});
                }
            });
        } else if (this.logger.isLoggable(Level.FINE)) {
            engine.addEvolutionObserver(new EvolutionObserver<FitnessPlanCandidate<T>>(){
                private long iter = 0L;

                public void populationUpdate(PopulationData<? extends FitnessPlanCandidate<T>> population) {
                    if (this.iter++ % 100L == 0L) {
                        GeneticHardcodedPlanner.this.logger.log(Level.FINE, "Candidate plan: {0}", population.getBestCandidate());
                    }
                }
            });
        }
        try (Event event = this.tracer.open(GeneticEventType.ENGINE);){
            GroupPlanCandidate planCandidate = (GroupPlanCandidate)engine.evolve(ThreadConfig.get(POPULATION_SIZE).intValue(), ThreadConfig.get(ELITE_COUNT).intValue(), new TerminationCondition[]{new Stagnation(ThreadConfig.get(STAGNATION).intValue(), true), new ElapsedTime((long)ThreadConfig.get(MAX_DURATION).intValue())});
            this.logger.log(Level.FINE, "Winner plan: {0}", planCandidate);
            GroupPlanCandidate groupPlanCandidate = planCandidate;
            return groupPlanCandidate;
        }
    }
}

