/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.filter.NoFilter;
import com.android.sched.item.Component;
import com.android.sched.schedulable.AdapterSchedulable;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Schedulable;
import com.android.sched.schedulable.VisitorSchedulable;
import com.android.sched.scheduler.ComponentFilterSet;
import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.ProcessException;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.ThreadWithTracer;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

@ImplementationName(iface=ScheduleInstance.class, name="single-threaded")
public class SingleScheduleInstance<T extends Component>
extends ScheduleInstance<T> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    protected SingleScheduleInstance(Plan<T> plan) throws Exception {
        super(plan);
    }

    @Override
    public <X extends VisitorSchedulable<T>, U extends Component> void process(@Nonnull T component) throws ProcessException {
        Worker worker = new Worker(this, this, component);
        ThreadWithTracer thread = new ThreadWithTracer(null, worker, ThreadConfig.getConfig().getName() + "-worker", ThreadConfig.get(ScheduleInstance.DEFAULT_STACK_SIZE));
        thread.setDaemon(true);
        ((Thread)thread).start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        worker.throwIfNecessary();
    }

    private static class Worker<U extends Component>
    implements Runnable {
        @Nonnull
        private final U component;
        @Nonnull
        private final SingleScheduleInstance<U> schedule;
        @CheckForNull
        private ProcessException exception;
        final /* synthetic */ SingleScheduleInstance this$0;

        public Worker(@Nonnull SingleScheduleInstance<U> schedule, U component) {
            this.this$0 = var1_1;
            this.component = component;
            this.schedule = schedule;
        }

        @Override
        public void run() {
            try {
                ComponentFilterSet filters = this.this$0.scheduler.createComponentFilterSet();
                filters.add(NoFilter.class);
                this.process(this.schedule, this.component, filters);
            }
            catch (ProcessException e) {
                this.exception = e;
            }
        }

        private <U extends Component> void process(@Nonnull SingleScheduleInstance<U> schedule, @Nonnull U component, @Nonnull ComponentFilterSet parentFilters) throws ProcessException {
            ComponentFilterSet currentFilters = schedule.applyFilters(parentFilters, component);
            for (ScheduleInstance.SchedStep step : schedule.steps) {
                Schedulable schedulable = step.getInstance();
                if (!step.isSkippable(currentFilters)) {
                    if (step instanceof ScheduleInstance.AdapterSchedStep) {
                        ScheduleInstance<Component> subSchedule = ((ScheduleInstance.AdapterSchedStep)step).getSubSchedInstance();
                        Iterator componentIter = schedule.adaptWithLog((AdapterSchedulable)schedulable, component);
                        while (componentIter.hasNext()) {
                            this.process((SingleScheduleInstance)subSchedule, (Component)componentIter.next(), currentFilters);
                        }
                        continue;
                    }
                    if (schedulable instanceof RunnableSchedulable) {
                        schedule.runWithLog((RunnableSchedulable)schedulable, component);
                        continue;
                    }
                    if (!(schedulable instanceof VisitorSchedulable)) continue;
                    schedule.visitWithLog((VisitorSchedulable)schedulable, component);
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.log(Level.FINER, "Skipping {0} ''{1}'' on ''{2}'' because requiring {3} but having {4}", new Object[]{step instanceof ScheduleInstance.RunnableSchedStep ? "runner" : "adapter", step.getName(), component, step.getRequiredFilters(), currentFilters});
            }
        }

        public void throwIfNecessary() throws ProcessException {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

