/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.Component;
import com.android.sched.item.Feature;
import com.android.sched.item.Production;
import com.android.sched.item.TagOrMarkerOrComponent;
import com.android.sched.schedulable.Schedulable;
import com.android.sched.scheduler.AdapterSet;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.IllegalRequestException;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.ManagedVisitor;
import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.PlanBuilder;
import com.android.sched.scheduler.PlanNotFoundException;
import com.android.sched.scheduler.PlannerFactory;
import com.android.sched.scheduler.ProductionSet;
import com.android.sched.scheduler.RunnerSet;
import com.android.sched.scheduler.SchedulableNotRegisteredError;
import com.android.sched.scheduler.SchedulableSet;
import com.android.sched.scheduler.Scheduler;
import com.android.sched.scheduler.TagOrMarkerOrComponentSet;

public class Request {
    @Nonnull
    private final Scheduler scheduler;
    @Nonnull
    protected TagOrMarkerOrComponentSet initialTags;
    @Nonnull
    protected TagOrMarkerOrComponentSet targetIncludeTags;
    @Nonnull
    protected TagOrMarkerOrComponentSet targetExcludeTags;
    @Nonnull
    protected ProductionSet targetProductions;
    @Nonnull
    protected FeatureSet features;
    @Nonnull
    protected RunnerSet runners;
    @CheckForNull
    protected RunnerSet candidateRunners = null;
    @Nonnull
    protected AdapterSet visitors = new AdapterSet();

    Request(@Nonnull Scheduler scheduler) {
        this.scheduler = scheduler;
        this.initialTags = scheduler.createTagOrMarkerOrComponentSet();
        this.targetIncludeTags = scheduler.createTagOrMarkerOrComponentSet();
        this.targetExcludeTags = scheduler.createTagOrMarkerOrComponentSet();
        this.targetProductions = scheduler.createProductionSet();
        this.features = scheduler.createFeatureSet();
        this.runners = new RunnerSet(scheduler.getSchedulableManager());
    }

    @Nonnull
    public Request addTargetIncludeTagOrMarker(@Nonnull Class<? extends TagOrMarkerOrComponent> tag) {
        this.targetIncludeTags.add(tag);
        return this;
    }

    @Nonnull
    public Request addTargetIncludeTagsOrMarkers(@Nonnull TagOrMarkerOrComponentSet set) {
        this.targetIncludeTags.addAll(set);
        return this;
    }

    @Nonnull
    public Request setTargetIncludeTagsOrMarkers(@Nonnull TagOrMarkerOrComponentSet set) {
        this.targetIncludeTags = set.clone();
        return this;
    }

    @Nonnull
    public Request addTargetExcludeTagOrMarker(@Nonnull Class<? extends TagOrMarkerOrComponent> tag) {
        this.targetExcludeTags.add(tag);
        return this;
    }

    @Nonnull
    public Request addTargetExcludeTagsOrMarkers(@Nonnull TagOrMarkerOrComponentSet set) {
        this.targetExcludeTags.addAll(set);
        return this;
    }

    @Nonnull
    public Request setTargetExcludeTagsOrMarkers(@Nonnull TagOrMarkerOrComponentSet set) {
        this.targetExcludeTags = set.clone();
        return this;
    }

    @Nonnull
    public Request addProduction(@Nonnull Class<? extends Production> production) {
        this.targetProductions.add(production);
        return this;
    }

    @Nonnull
    public Request addProductions(@Nonnull ProductionSet set) {
        this.targetProductions.addAll(set);
        return this;
    }

    @Nonnull
    public Request setProductions(@Nonnull ProductionSet set) {
        this.targetProductions = set.clone();
        return this;
    }

    @Nonnull
    public Request addFeature(@Nonnull Class<? extends Feature> feature) {
        this.features.add(feature);
        this.candidateRunners = null;
        return this;
    }

    @Nonnull
    public Request addFeatures(@Nonnull FeatureSet set) {
        this.features.addAll(set);
        return this;
    }

    @Nonnull
    public Request setFeatures(@Nonnull FeatureSet set) {
        this.features = set.clone();
        return this;
    }

    @Nonnull
    public Request addInitialTagOrMarker(@Nonnull Class<? extends TagOrMarkerOrComponent> tag) {
        this.initialTags.add(tag);
        return this;
    }

    @Nonnull
    public Request addInitialTagsOrMarkers(@Nonnull TagOrMarkerOrComponentSet set) {
        this.initialTags.addAll(set);
        return this;
    }

    @Nonnull
    public Request setInitialTagsOrMarkers(@Nonnull TagOrMarkerOrComponentSet set) {
        this.initialTags = set.clone();
        return this;
    }

    @Nonnull
    public Request addSchedulable(@Nonnull Class<? extends Schedulable> sched) {
        ManagedSchedulable schedulable = this.scheduler.getSchedulableManager().getManagedSchedulable(sched);
        if (schedulable == null) {
            throw new SchedulableNotRegisteredError(sched);
        }
        if (schedulable instanceof ManagedRunnable) {
            ManagedRunnable runner = (ManagedRunnable)schedulable;
            this.runners.add(runner);
            this.candidateRunners = null;
        } else if (schedulable instanceof ManagedVisitor) {
            this.visitors.add((ManagedVisitor)schedulable);
        } else {
            throw new AssertionError();
        }
        return this;
    }

    @Nonnull
    public Request addSchedulables(@Nonnull SchedulableSet set) {
        for (ManagedSchedulable sched : set.getAll()) {
            if (sched.isRunnable()) {
                ManagedRunnable runner = (ManagedRunnable)sched;
                this.runners.add(runner);
                this.candidateRunners = null;
                continue;
            }
            if (sched.isVisitor()) {
                this.visitors.add((ManagedVisitor)sched);
                continue;
            }
            assert (false);
        }
        return this;
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getInitialTags() {
        return this.initialTags.clone();
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getTargetIncludeTags() {
        return this.targetIncludeTags.clone();
    }

    @Nonnull
    public TagOrMarkerOrComponentSet getTargetExcludeTags() {
        return this.targetExcludeTags.clone();
    }

    @Nonnull
    public ProductionSet getTargetProductions() {
        return this.targetProductions.clone();
    }

    @Nonnull
    public FeatureSet getFeatures() {
        return this.features.clone();
    }

    @Nonnull
    public RunnerSet getRunners() {
        if (this.candidateRunners == null) {
            this.candidateRunners = new RunnerSet(this.runners);
            for (ManagedRunnable runner : this.runners) {
                if (this.features.containsAll(runner.getSupportedFeatures())) continue;
                this.candidateRunners.remove(runner);
            }
        }
        return this.candidateRunners;
    }

    @Nonnull
    public AdapterSet getVisitors() {
        return this.visitors;
    }

    @Nonnull
    public <T extends Component> Plan<T> buildPlan(@Nonnull Class<T> on) throws PlanNotFoundException, IllegalRequestException {
        return PlannerFactory.createPlanner().buildPlan(this, on);
    }

    @Nonnull
    public <T extends Component> PlanBuilder<T> getPlanBuilder(@Nonnull Class<T> runOn) throws IllegalRequestException {
        return new PlanBuilder<T>(this, runOn);
    }

    @Nonnull
    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

