/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.Component;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.ManagedVisitor;
import com.android.sched.scheduler.Plan;

public class PlanStep {
    @Nonnull
    private final ManagedSchedulable schedulable;
    @CheckForNull
    private final Plan<? extends Component> subPlan;

    PlanStep(@Nonnull ManagedVisitor visitor, @Nonnull Plan<? extends Component> subPlan) {
        this.schedulable = visitor;
        this.subPlan = subPlan;
    }

    PlanStep(@Nonnull ManagedRunnable runner) {
        this.schedulable = runner;
        this.subPlan = null;
    }

    public boolean isVisitor() {
        return this.subPlan != null;
    }

    public boolean isRunner() {
        return this.subPlan == null;
    }

    @Nonnull
    public ManagedSchedulable getManagedSchedulable() {
        return this.schedulable;
    }

    @Nonnull
    public ManagedRunnable getManagedRunner() {
        return (ManagedRunnable)this.schedulable;
    }

    @Nonnull
    public ManagedVisitor getManagedVisitor() {
        return (ManagedVisitor)this.schedulable;
    }

    @Nonnull
    public Plan<? extends Component> getSubPlan() {
        if (this.subPlan == null) {
            throw new IllegalStateException();
        }
        return this.subPlan;
    }
}

