/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.Plan;
import com.android.sched.scheduler.PlanPrinter;
import com.android.sched.scheduler.PlanPrinterFactory;
import com.android.sched.scheduler.PlanStep;
import com.android.sched.util.codec.ImplementationName;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WriterFile;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.stream.CustomPrintWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;

@ImplementationName(iface=PlanPrinter.class, name="serializer")
public class PlanSerializer
implements PlanPrinter {
    @Nonnull
    private static Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final WriterFile planFile = ThreadConfig.get(PlanPrinterFactory.PLAN_PRINTER_FILE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printPlan(@Nonnull Plan<?> plan) throws CannotWriteException {
        CustomPrintWriter writer = null;
        try {
            writer = this.planFile.getPrintWriter();
            this.printSubPlan(plan, writer);
        }
        finally {
            if (writer != null) {
                writer.close();
                try {
                    writer.throwPendingException();
                }
                catch (IOException e) {
                    throw new CannotWriteException(this.planFile.getLocation(), (Throwable)e);
                }
            }
        }
    }

    private void printSubPlan(@Nonnull Plan<?> plan, @Nonnull PrintWriter writer) {
        for (PlanStep step : plan) {
            ManagedSchedulable schedulable = step.getManagedSchedulable();
            writer.println(schedulable.getSchedulable().getCanonicalName());
            if (!step.isVisitor()) continue;
            writer.println("{");
            this.printSubPlan(step.getSubPlan(), writer);
            writer.println("}");
        }
    }
}

