/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.Component;
import com.android.sched.schedulable.AdapterSchedulable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.SchedulableNotConformException;
import com.android.sched.util.Reflect;
import com.android.sched.util.log.LoggerFactory;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.logging.Level;

public class ManagedVisitor
extends ManagedSchedulable {
    @Nonnull
    private final Class<? extends AdapterSchedulable<? extends Component, ? extends Component>> visitor;
    @Nonnull
    private final Class<? extends Component> schedulableOn;
    @Nonnull
    private final Class<? extends Component> visitorTo;

    public ManagedVisitor(@Nonnull Class<? extends AdapterSchedulable<? extends Component, ? extends Component>> visitor) throws SchedulableNotConformException {
        super(visitor);
        this.visitor = visitor;
        this.schedulableOn = this.extractSchedulableOn();
        this.visitorTo = this.extractVisitorTo();
        if (this.schedulableOn == this.visitorTo) {
            throw new SchedulableNotConformException("VisitorSchedulable '" + this.getName() + "' can not adapt from/to the same type '" + this.schedulableOn.getCanonicalName() + "'");
        }
        LoggerFactory.getLogger().log(Level.CONFIG, "{0}", this);
    }

    @Nonnull
    public <T> Class<? extends AdapterSchedulable<? extends Component, ? extends Component>> getVisitorSchedulable() {
        return this.visitor;
    }

    @Override
    public boolean isVisitor() {
        return true;
    }

    @Override
    public boolean isRunnable() {
        return false;
    }

    @Nonnull
    public Class<? extends Component> getRunOnAfter() {
        return this.visitorTo;
    }

    @Override
    @Nonnull
    public Class<? extends Component> getRunOn() {
        return this.schedulableOn;
    }

    @Nonnull
    private Class<? extends Component> extractSchedulableOn() {
        for (Type intf : Reflect.getAllGenericInSuperClassOrInterface(this.visitor)) {
            ParameterizedType pt;
            if (!(intf instanceof ParameterizedType) || !AdapterSchedulable.class.isAssignableFrom((Class)(pt = (ParameterizedType)intf).getRawType())) continue;
            return (Class)pt.getActualTypeArguments()[0];
        }
        throw new AssertionError();
    }

    @Nonnull
    private Class<? extends Component> extractVisitorTo() {
        for (Type intf : Reflect.getAllGenericInSuperClassOrInterface(this.visitor)) {
            ParameterizedType pt;
            if (!(intf instanceof ParameterizedType) || !AdapterSchedulable.class.isAssignableFrom((Class)(pt = (ParameterizedType)intf).getRawType())) continue;
            return (Class)pt.getActualTypeArguments()[1];
        }
        throw new AssertionError();
    }

    @Override
    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Visitor '");
        sb.append(this.getName());
        sb.append('\'');
        return new String(sb);
    }
}

