/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.marker;

import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.SchedProperties;
import com.android.sched.item.Items;
import com.android.sched.item.onlyfor.Default;
import com.android.sched.item.onlyfor.OnlyForType;
import com.android.sched.marker.ManagedMarker;
import com.android.sched.marker.Marker;
import com.android.sched.marker.MarkerManager;
import com.android.sched.marker.MarkerNotConformException;
import com.android.sched.reflections.ReflectionFactory;
import com.android.sched.reflections.ReflectionManager;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.ManagedVisitor;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.log.LoggerFactory;
import java.lang.reflect.Modifier;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AbstractMarkerManager
implements MarkerManager {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @CheckForNull
    private static Map<Class<? extends Marker>, ManagedMarker> map = null;
    @Nonnull
    private static Class<? extends OnlyForType> onlyFor = ThreadConfig.get(SchedProperties.ONLY_FOR);
    private static final boolean FAILED_STOP = ThreadConfig.get(SchedProperties.FAILED_STOP);

    AbstractMarkerManager() {
    }

    protected boolean isValidMarker(@Nonnull Class<? extends Marker> marker) {
        AbstractMarkerManager.ensureScan();
        assert (map != null);
        return map.get(marker).isValidMarker(this);
    }

    protected boolean isValidMarker(@Nonnull Marker marker) {
        AbstractMarkerManager.ensureScan();
        assert (map != null);
        return map.get(marker.getClass()).isValidMarker(this, marker);
    }

    protected boolean checkRemoveAccess(@Nonnull Class<? extends Marker> marker) {
        ManagedRunnable runner = AbstractMarkerManager.getCurrentSchedulable();
        if (runner != null && !runner.getRemovedTags().contains(marker)) {
            throw new AssertionError((Object)("SchedulableRunnable '" + runner.getName() + "' try to remove marker '" + Items.getName(marker) + "' without 'remove' specification on it."));
        }
        return true;
    }

    protected boolean checkAddAccess(@Nonnull Class<? extends Marker> marker) {
        ManagedRunnable runner = AbstractMarkerManager.getCurrentSchedulable();
        if (runner != null && !runner.getAddedTags().contains(marker)) {
            throw new AssertionError((Object)("SchedulableRunnable '" + runner.getName() + "' try to add marker '" + Items.getName(marker) + "' without 'add' specification on it."));
        }
        return true;
    }

    protected boolean checkGetAccess(@Nonnull Class<? extends Marker> marker) {
        FeatureSet features;
        ManagedRunnable runner = AbstractMarkerManager.getCurrentSchedulable();
        if (runner != null && (features = ScheduleInstance.getCurrentFeatures()) != null && runner.getUnsupportedTags(features).contains(marker)) {
            throw new AssertionError((Object)("SchedulableRunnable '" + runner.getName() + "' try to get marker '" + Items.getName(marker) + "' with a 'no' specification on it."));
        }
        return true;
    }

    @CheckForNull
    private static ManagedRunnable getCurrentSchedulable() {
        ManagedSchedulable schedulable = null;
        AbstractMarkerManager.ensureScan();
        assert (map != null);
        try {
            schedulable = ScheduleInstance.getCurrentSchedulable();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (schedulable != null && schedulable instanceof ManagedVisitor) {
            throw new AssertionError((Object)("Schedulable '" + schedulable.getName() + "' try use marker but it is not a SchedulableRunnable."));
        }
        return (ManagedRunnable)schedulable;
    }

    private static void registerMarker(@Nonnull Class<? extends Marker> marker) throws MarkerNotConformException {
        assert (map != null);
        try {
            map.put(marker, new ManagedMarker(marker));
            logger.log(Level.INFO, "Register marker ''{0}'' ({1})", new Object[]{marker.getName(), marker.getCanonicalName()});
        }
        catch (MarkerNotConformException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    private static synchronized void ensureScan() {
        if (map == null) {
            map = new HashMap<Class<? extends Marker>, ManagedMarker>();
            ReflectionManager reflectionManager = ReflectionFactory.getManager();
            for (Class<Marker> marker : reflectionManager.getSubTypesOf(Marker.class)) {
                try {
                    Class<? extends OnlyForType> onlyFor = Items.getOnlyForType(marker);
                    if (AbstractMarkerManager.onlyFor == null || onlyFor == Default.class || onlyFor == AbstractMarkerManager.onlyFor) {
                        if (Modifier.isAbstract(marker.getModifiers()) || marker.isInterface()) continue;
                        AbstractMarkerManager.registerMarker(marker);
                        continue;
                    }
                    logger.log(Level.INFO, "Marker ''{0}'' ({1}) is ignored because only for {2}", new Object[]{Items.getName(marker), marker.getCanonicalName(), onlyFor.getSimpleName()});
                }
                catch (MarkerNotConformException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                    if (!FAILED_STOP) continue;
                    throw e;
                }
            }
        }
    }
}

