/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.item;

import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import com.android.sched.item.AbstractItemManager;
import com.android.sched.item.Item;
import com.android.sched.item.ManagedItem;

public class ManagedConcreteItem
extends ManagedItem {
    private int posInteger = -1;
    private int posBit = -1;

    public ManagedConcreteItem(@Nonnull Class<? extends Item> item, @Nonnull AbstractItemManager manager) {
        super(item, manager);
    }

    public ManagedConcreteItem(@Nonnull Class<? extends Item> item, @Nonnull AbstractItemManager manager, @Nonnegative int posInteger, @Nonnegative int posBits) {
        super(item, manager);
        this.posInteger = posInteger;
        this.posBit = posBits;
    }

    public void setPosition(@Nonnegative int posInteger, @Nonnegative int posBits) {
        this.posInteger = posInteger;
        this.posBit = posBits;
    }

    @Override
    protected void ensureBitmap() {
        if (this.bitmap == null) {
            super.ensureBitmap();
            assert (this.bitmap != null);
            this.bitmap[this.posInteger] = 1L << this.posBit;
        }
    }

    @Nonnegative
    public int getPosInteger() {
        assert (this.posInteger >= 0);
        return this.posInteger;
    }

    @Nonnegative
    public int getPosBit() {
        assert (this.posBit >= 0);
        return this.posBit;
    }

    @Override
    @Nonnull
    public String toString() {
        assert (this.posInteger >= 0) : "name: " + this.getName() + ", posInteger: " + this.posInteger;
        assert (this.posBit >= 0) : "name: " + this.getName() + ", posBit: " + this.posBit;
        StringBuilder sb = new StringBuilder();
        sb.append("Item '");
        sb.append(this.getName());
        sb.append("' id <");
        sb.append(this.posInteger);
        sb.append(", ");
        sb.append(this.posBit);
        sb.append('>');
        return new String(sb);
    }
}

