/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.backend.jayce;

import com.android.jill.backend.jayce.JayceOutputStream;
import com.android.jill.backend.jayce.JayceWriter;
import com.android.jill.backend.jayce.Token;
import com.android.jill.google.common.base.Strings;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnegative;
import com.android.jill.javax.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;

public class JaycePrettyWriter
extends JayceWriter {
    @Nonnull
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    @Nonnull
    private static final String INDENT_GRANULARITY = "  ";
    @Nonnegative
    private int indent = 0;

    public JaycePrettyWriter(@Nonnull OutputStream out) {
        super(out);
    }

    @Override
    public void writeKeyword(@Nonnull Token token) throws IOException {
        this.writeIdent();
        super.writeKeyword(token);
        this.writeLn();
    }

    @Override
    public void writeOpen() throws IOException {
        this.writeIdent();
        super.writeOpen();
        this.writeLn();
        this.indentIn();
    }

    @Override
    public void writeClose() throws IOException {
        this.indentOut();
        this.writeIdent();
        super.writeClose();
        this.writeLn();
    }

    @Override
    public void writeString(@CheckForNull String string) throws IOException {
        this.writeIdent();
        super.writeString(string);
        this.writeLn();
    }

    @Override
    public void writeNull() throws IOException {
        this.writeIdent();
        super.writeNull();
    }

    @Override
    public void writeFileName(@CheckForNull String fileName) throws IOException {
        this.writeIdent();
        super.writeFileName(fileName);
        this.writeLn();
    }

    @Override
    public void writeCurrentLineInfo(int lineNumber) throws IOException {
        this.writeIdent();
        super.writeCurrentLineInfo(lineNumber);
        this.writeLn();
    }

    @Override
    protected void writeSpace() throws IOException {
        this.writeLn();
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.writeIdent();
        super.writeInt(value);
    }

    @Override
    public void writeByte(byte value) throws IOException {
        this.writeIdent();
        super.writeByte(value);
    }

    @Override
    public void writeChar(char value) throws IOException {
        this.writeIdent();
        super.writeChar(value);
    }

    @Override
    public void writeShort(short value) throws IOException {
        this.writeIdent();
        super.writeShort(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.writeIdent();
        super.writeLong(value);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.writeIdent();
        super.writeFloat(value);
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writeIdent();
        super.writeDouble(value);
    }

    private void writeIdent() throws IOException {
        ((JayceOutputStream)this.writers.peek()).writeChars(Strings.repeat(INDENT_GRANULARITY, this.indent));
    }

    private void writeLn() throws IOException {
        ((JayceOutputStream)this.writers.peek()).writeChars(LINE_SEPARATOR);
    }

    private void indentIn() {
        ++this.indent;
    }

    private void indentOut() {
        --this.indent;
    }
}

