/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.api.v01.impl;

import com.android.jill.Main;
import com.android.jill.Options;
import com.android.jill.api.v01.Cli01Config;
import com.android.jill.api.v01.Cli01TranslationTask;
import com.android.jill.api.v01.ConfigurationException;
import com.android.jill.javax.annotation.CheckForNull;
import com.android.jill.javax.annotation.Nonnull;
import com.android.jill.kohsuke.args4j.CmdLineException;
import com.android.sched.util.file.SchedIOException;
import java.io.File;
import java.io.PrintStream;

public class Cli01ConfigImpl
implements Cli01Config {
    @CheckForNull
    private PrintStream standardError;
    @Nonnull
    private File workingDirectory = new File(".");

    @Override
    @Nonnull
    public Cli01TranslationTask getTask(@Nonnull String[] args) throws ConfigurationException {
        try {
            Options options = Main.getOptions(args);
            options.setStandardError(this.standardError);
            options.setWorkingDirectory(this.workingDirectory);
            return new Cli01TranslationTaskImpl(options);
        }
        catch (CmdLineException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        catch (SchedIOException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public void setStandardError(@Nonnull PrintStream standardError) {
        this.standardError = standardError;
    }

    @Override
    public void setStandardOutput(@Nonnull PrintStream standardOutput) {
    }

    @Override
    public void setWorkingDirectory(@Nonnull File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    private static class Cli01TranslationTaskImpl
    extends Main
    implements Cli01TranslationTask {
        @Nonnull
        private final Options options;

        public Cli01TranslationTaskImpl(@Nonnull Options options) {
            this.options = options;
        }

        @Override
        public int run() {
            PrintStream err = this.options.getStandardError();
            if (err == null) {
                err = System.err;
            }
            return Cli01TranslationTaskImpl.runJill(err, this.options);
        }
    }
}

