/*
 * Decompiled with CFR 0.152.
 */
package com.android.jill.api.v01.impl;

import com.android.jill.Jill;
import com.android.jill.Options;
import com.android.jill.api.v01.Api01Config;
import com.android.jill.api.v01.Api01TranslationTask;
import com.android.jill.api.v01.ConfigurationException;
import com.android.jill.javax.annotation.Nonnull;
import com.android.jill.utils.FileUtils;
import java.io.File;

public class Api01ConfigImpl
implements Api01Config {
    @Nonnull
    private final Options options = new Options();

    @Override
    @Nonnull
    public Api01TranslationTask getTask() {
        return new Api01TranslationTaskImpl(this.options);
    }

    @Override
    public void setVerbose(boolean isVerbose) {
        this.options.setVerbose(isVerbose);
    }

    @Override
    public void setInputJavaBinaryFile(@Nonnull File input) throws ConfigurationException {
        if (!input.exists()) {
            throw new ConfigurationException("Input file does not exist: " + input.getPath());
        }
        if (!input.getAbsoluteFile().isFile()) {
            throw new ConfigurationException("Input is not a file: " + input.getPath());
        }
        if (!FileUtils.isJarFile(input)) {
            throw new ConfigurationException("Unsupported file type: " + input.getName());
        }
        this.options.setBinaryFile(input);
    }

    @Override
    public void setOutputJackFile(@Nonnull File outputJackFile) {
        this.options.setOutput(outputJackFile);
    }

    @Override
    public void setDebugInfo(boolean debugInfo) {
        this.options.setEmitDebugInfo(debugInfo);
    }

    private static class Api01TranslationTaskImpl
    implements Api01TranslationTask {
        @Nonnull
        private final Options options;

        public Api01TranslationTaskImpl(@Nonnull Options options) {
            this.options = options;
        }

        @Override
        public void run() {
            Jill.process(this.options);
        }
    }
}

