/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.adb;

public class LinearInterpolator {
    private final int steps;

    public LinearInterpolator(int steps) {
        this.steps = steps;
    }

    private static float lerp(float start, float stop, float amount) {
        return start + (stop - start) * amount;
    }

    public void interpolate(Point start, Point end, Callback callback) {
        int xDistance = Math.abs(end.getX() - start.getX());
        int yDistance = Math.abs(end.getY() - start.getY());
        float amount = (float)(1.0 / (double)this.steps);
        callback.start(start);
        for (int i = 1; i < this.steps; ++i) {
            float newX = LinearInterpolator.lerp(start.getX(), end.getX(), amount * (float)i);
            float newY = LinearInterpolator.lerp(start.getY(), end.getY(), amount * (float)i);
            callback.step(new Point(Math.round(newX), Math.round(newY)));
        }
        callback.end(end);
    }

    public static interface Callback {
        public void start(Point var1);

        public void end(Point var1);

        public void step(Point var1);
    }

    public static class Point {
        private final int x;
        private final int y;

        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof Point) {
                Point that = (Point)obj;
                return this.x == that.x && this.y == that.y;
            }
            return false;
        }

        public int hashCode() {
            return 1125274389 + this.x + this.y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

