/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.DelegatingProgressIndicator;

public interface ProgressIndicator {
    public void setText(String var1);

    public boolean isCanceled();

    public void cancel();

    public void setCancellable(boolean var1);

    public boolean isCancellable();

    public void setIndeterminate(boolean var1);

    public boolean isIndeterminate();

    public void setFraction(double var1);

    public double getFraction();

    public void setSecondaryText(String var1);

    public void logWarning(String var1);

    public void logWarning(String var1, Throwable var2);

    public void logError(String var1);

    public void logError(String var1, Throwable var2);

    public void logInfo(String var1);

    default public void logVerbose(String s) {
        this.logInfo(s);
    }

    default public ProgressIndicator createSubProgress(double max) {
        final double start = this.getFraction();
        if (start == 1.0) {
            return this;
        }
        final double subRange = max - start;
        if (subRange < -1.0E-4 || subRange > 1.0001) {
            this.logError("Progress subrange out of bounds: " + subRange);
        }
        return new DelegatingProgressIndicator(this){

            @Override
            public void setFraction(double subFraction) {
                if (subRange > 0.0) {
                    subFraction = Math.min(1.0, Math.max(0.0, subFraction));
                    super.setFraction(start + subFraction * subRange);
                }
            }

            @Override
            public double getFraction() {
                return Math.min(1.0, Math.max(0.0, subRange > 0.0 ? (super.getFraction() - start) / subRange : 0.0));
            }
        };
    }
}

