/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.DataFile;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

abstract class DataItem<F extends DataFile>
implements Serializable {
    private static final int MASK_TOUCHED = 1;
    private static final int MASK_REMOVED = 2;
    private static final int MASK_WRITTEN = 16;
    private final String mName;
    private F mSource;
    private int mStatus = 0;

    DataItem(String name) {
        this.mName = (String)Preconditions.checkNotNull((Object)name);
    }

    public String getName() {
        return this.mName;
    }

    public F getSource() {
        return this.mSource;
    }

    public void setSource(F sourceFile) {
        this.mSource = sourceFile;
    }

    DataItem<F> resetStatus() {
        this.mStatus = 0;
        return this;
    }

    DataItem<F> resetStatusToWritten() {
        this.mStatus = 16;
        return this;
    }

    DataItem<F> resetStatusToTouched() {
        boolean wasNotTouched = !this.isTouched();
        this.mStatus = 1;
        if (!wasNotTouched) {
            this.wasTouched();
        }
        return this;
    }

    DataItem<F> setWritten() {
        this.mStatus |= 0x10;
        return this;
    }

    DataItem<F> setRemoved() {
        this.mStatus |= 2;
        return this;
    }

    DataItem<F> setTouched() {
        if (!this.isTouched()) {
            this.mStatus |= 1;
            this.wasTouched();
        }
        return this;
    }

    boolean isRemoved() {
        return (this.mStatus & 2) != 0;
    }

    boolean isTouched() {
        return (this.mStatus & 1) != 0;
    }

    boolean isWritten() {
        return (this.mStatus & 0x10) != 0;
    }

    protected int getStatus() {
        return this.mStatus;
    }

    public String getKey() {
        return this.mName;
    }

    void addExtraAttributes(Document document, Node node, String namespaceUri) {
    }

    Node getDetailsXml(Document document) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataItem dataItem = (DataItem)o;
        return Objects.equal((Object)this.mName, (Object)dataItem.mName) && Objects.equal(this.mSource, dataItem.mSource);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mName, this.mSource});
    }

    protected void wasTouched() {
    }

    public File getFile() {
        return ((DataFile)this.getSource()).getFile();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this.mName).add("source", this.mSource).add("isRemoved", this.isRemoved()).add("isTouched", this.isTouched()).add("isWritten", this.isWritten()).toString();
    }
}

