/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EllipsizeMaxLinesDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(EllipsizeMaxLinesDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"EllipsizeMaxLines", (String)"Combining Ellipsize and Maxlines", (String)"Combining `ellipsize` and `maxLines=1` can lead to crashes on some devices. Earlier versions of lint recommended replacing `singleLine=true` with `maxLines=1` but that should not be done when using `ellipsize`.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION).addMoreInfo("https://issuetracker.google.com/issues/36950033");
    public static final String ATTR_ELLIPSIZE = "ellipsize";
    public static final String ATTR_LINES = "lines";
    public static final String ATTR_MAX_LINES = "maxLines";

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT;
    }

    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList(ATTR_ELLIPSIZE);
    }

    public void visitAttribute(XmlContext context, Attr attribute) {
        if ("end".equals(attribute.getValue())) {
            return;
        }
        Element element = attribute.getOwnerElement();
        Attr lines = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_LINES);
        Attr maxLines = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_MAX_LINES);
        if (lines != null && "1".equals(lines.getValue()) || maxLines != null && "1".equals(maxLines.getValue())) {
            Attr other = lines != null ? lines : maxLines;
            Location location = context.getLocation((Node)other);
            location.setSecondary(context.getLocation((Node)attribute));
            LintFix fix = EllipsizeMaxLinesDetector.fix().name("Replace with singleLine=\"true\"").composite(new LintFix[]{EllipsizeMaxLinesDetector.fix().set("http://schemas.android.com/apk/res/android", "singleLine", "true").build(), EllipsizeMaxLinesDetector.fix().unset("http://schemas.android.com/apk/res/android", other.getLocalName()).build()});
            context.report(ISSUE, (Node)attribute, location, String.format("Combining `ellipsize=%1$s` and `%2$s=%3$s` can lead to crashes. Use `singleLine=true` instead.", element.getAttributeNS("http://schemas.android.com/apk/res/android", ATTR_ELLIPSIZE), other.getLocalName(), other.getValue()), fix);
        }
    }
}

