/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.java.JavaUAssertExpression;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\u0018\u00010\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/AssertDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "checkAssertion", "", "expression", "Lorg/jetbrains/uast/java/JavaUAssertExpression;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "isNullCheck", "", "Lorg/jetbrains/uast/UExpression;", "Issues", "lint-checks_main"})
public final class AssertDetector
extends Detector
implements Detector.UastScanner {
    @JvmField
    public static final Issue ISSUE;
    public static final Issues Issues;

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!context.getMainProject().isAndroidProject()) {
            return null;
        }
        return new UElementHandler(this, context){
            final /* synthetic */ AssertDetector this$0;
            final /* synthetic */ JavaContext $context;

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (node instanceof JavaUAssertExpression) {
                    AssertDetector.access$checkAssertion(this.this$0, (JavaUAssertExpression)node, this.$context);
                }
            }
            {
                this.this$0 = $outer;
                this.$context = $captured_local_variable$1;
            }
        };
    }

    private final void checkAssertion(JavaUAssertExpression expression, JavaContext context) {
        Object value;
        UExpression condition = expression.getCondition();
        if (condition instanceof ULiteralExpression ? Intrinsics.areEqual((Object)Boolean.TRUE, (Object)(value = ((ULiteralExpression)condition).getValue())) : this.isNullCheck(condition)) {
            return;
        }
        String message = "Assertions are unreliable in Dalvik and unimplemented in ART. Use `BuildConfig.DEBUG` conditional checks instead.";
        PsiElement firstChild = expression.getPsi().getFirstChild();
        Location location = firstChild instanceof PsiKeyword && Intrinsics.areEqual((Object)"assert", (Object)firstChild.getText()) ? context.getLocation(firstChild) : context.getLocation((UElement)expression);
        Issue issue = ISSUE;
        Intrinsics.checkExpressionValueIsNotNull((Object)issue, (String)"ISSUE");
        JavaContext.report$default((JavaContext)context, (Issue)issue, (UElement)((UElement)expression), (Location)location, (String)message, null, (int)16, null);
    }

    private final boolean isNullCheck(UExpression expression) {
        boolean bl;
        if (expression instanceof UParenthesizedExpression) {
            return this.isNullCheck(((UParenthesizedExpression)expression).getExpression());
        }
        UExpression uExpression = expression;
        if (uExpression instanceof UBinaryExpression) {
            UExpression lOperand = ((UBinaryExpression)expression).getLeftOperand();
            UExpression rOperand = ((UBinaryExpression)expression).getRightOperand();
            bl = UastLiteralUtils.isNullLiteral((UElement)((UElement)lOperand)) || UastLiteralUtils.isNullLiteral((UElement)((UElement)rOperand)) || this.isNullCheck(lOperand) && this.isNullCheck(rOperand);
        } else if (uExpression instanceof UPolyadicExpression) {
            for (UExpression operand : ((UPolyadicExpression)expression).getOperands()) {
                if (this.isNullCheck(operand)) continue;
                return false;
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    static {
        Issues = new Issues(null);
        ISSUE = Issue.create((String)"Assert", (String)"Assertions", (String)"\nAssertions are not checked at runtime. There are ways to request that they be used by Dalvik \\\n(`adb shell setprop debug.assert 1`), but note that this is not implemented in ART (the newer \\\nruntime), and even in Dalvik the property is ignored in many places and can not be relied upon. \\\nInstead, perform conditional checking inside `if (BuildConfig.DEBUG) { }` blocks. That constant \\\nis a static final boolean which is true in debug builds and false in release builds, and the \\\nJava compiler completely removes all code inside the if-body from the app.\n\nFor example, you can replace `assert speed > 0` with `if (BuildConfig.DEBUG && !(speed > 0)) { \\\nthrow new AssertionError() }`.\n\n(Note: This lint check does not flag assertions purely asserting nullness or non-nullness; these \\\nare typically more intended for tools usage than runtime checks.)", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(AssertDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("https://code.google.com/p/android/issues/detail?id=65183");
    }

    public static final /* synthetic */ void access$checkAssertion(AssertDetector $this, @NotNull JavaUAssertExpression expression, @NotNull JavaContext context) {
        $this.checkAssertion(expression, context);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/AssertDetector$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "kotlin.jvm.PlatformType", "lint-checks_main"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

