/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.Call;
import com.android.traceview.MethodData;
import com.android.traceview.ProfileProvider;
import com.android.traceview.ThreadData;
import com.android.traceview.TimeBase;
import com.android.traceview.TimeLineView;
import com.android.traceview.TraceAction;
import com.android.traceview.TraceReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DmTraceReader
extends TraceReader {
    private static final int TRACE_MAGIC = 1464814675;
    private static final int METHOD_TRACE_ENTER = 0;
    private static final int METHOD_TRACE_EXIT = 1;
    private static final int METHOD_TRACE_UNROLL = 2;
    private static final long MIN_CONTEXT_SWITCH_TIME_USEC = 100L;
    private int mVersionNumber;
    private boolean mRegression;
    private ProfileProvider mProfileProvider;
    private String mTraceFileName;
    private MethodData mTopLevel;
    private ArrayList<Call> mCallList;
    private HashMap<String, String> mPropertiesMap;
    private HashMap<Integer, MethodData> mMethodMap;
    private HashMap<Integer, ThreadData> mThreadMap;
    private ThreadData[] mSortedThreads;
    private MethodData[] mSortedMethods;
    private long mTotalCpuTime;
    private long mTotalRealTime;
    private MethodData mContextSwitch;
    private int mRecordSize;
    private ClockSource mClockSource;
    private static final Pattern mIdNamePattern = Pattern.compile("(\\d+)\t(.*)");
    static final int PARSE_VERSION = 0;
    static final int PARSE_THREADS = 1;
    static final int PARSE_METHODS = 2;
    static final int PARSE_OPTIONS = 4;

    public DmTraceReader(String traceFileName, boolean regression) throws IOException {
        this.mTraceFileName = traceFileName;
        this.mRegression = regression;
        this.mPropertiesMap = new HashMap();
        this.mMethodMap = new HashMap();
        this.mThreadMap = new HashMap();
        this.mCallList = new ArrayList();
        this.mTopLevel = new MethodData(0, "(toplevel)");
        this.mContextSwitch = new MethodData(-1, "(context switch)");
        this.mMethodMap.put(0, this.mTopLevel);
        this.mMethodMap.put(-1, this.mContextSwitch);
        this.generateTrees();
    }

    void generateTrees() throws IOException {
        long offset = this.parseKeys();
        this.parseData(offset);
        this.analyzeData();
    }

    @Override
    public ProfileProvider getProfileProvider() {
        if (this.mProfileProvider == null) {
            this.mProfileProvider = new ProfileProvider(this);
        }
        return this.mProfileProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MappedByteBuffer mapFile(String filename, long offset) throws IOException {
        MappedByteBuffer buffer = null;
        try (FileInputStream dataFile = new FileInputStream(filename);){
            File file = new File(filename);
            FileChannel fc = dataFile.getChannel();
            buffer = fc.map(FileChannel.MapMode.READ_ONLY, offset, file.length() - offset);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            MappedByteBuffer mappedByteBuffer = buffer;
            return mappedByteBuffer;
        }
    }

    private void readDataFileHeader(MappedByteBuffer buffer) {
        int magic = buffer.getInt();
        if (magic != 1464814675) {
            System.err.printf("Error: magic number mismatch; got 0x%x, expected 0x%x\n", magic, 1464814675);
            throw new RuntimeException();
        }
        short version = buffer.getShort();
        if (version != this.mVersionNumber) {
            System.err.printf("Error: version number mismatch; got %d in data header but %d in options\n", version, this.mVersionNumber);
            throw new RuntimeException();
        }
        if (version < 1 || version > 3) {
            System.err.printf("Error: unsupported trace version number %d.  Please use a newer version of TraceView to read this file.", version);
            throw new RuntimeException();
        }
        int offsetToData = buffer.getShort() - 16;
        buffer.getLong();
        if (version == 1) {
            this.mRecordSize = 9;
        } else if (version == 2) {
            this.mRecordSize = 10;
        } else {
            this.mRecordSize = buffer.getShort();
            offsetToData -= 2;
        }
        while (offsetToData-- > 0) {
            buffer.get();
        }
    }

    private void parseData(long offset) throws IOException {
        ThreadData prevThreadData;
        boolean haveGlobalClock;
        ArrayList<TraceAction> trace;
        block41: {
            int methodAction;
            MappedByteBuffer buffer = this.mapFile(this.mTraceFileName, offset);
            this.readDataFileHeader(buffer);
            trace = null;
            if (this.mClockSource == ClockSource.THREAD_CPU) {
                trace = new ArrayList<TraceAction>();
            }
            boolean haveThreadClock = this.mClockSource != ClockSource.WALL;
            haveGlobalClock = this.mClockSource != ClockSource.THREAD_CPU;
            prevThreadData = null;
            block10: while (true) {
                ThreadData threadData;
                long globalTime;
                long threadTime;
                int methodId;
                short threadId;
                try {
                    int recordSize = this.mRecordSize;
                    if (this.mVersionNumber == 1) {
                        threadId = buffer.get();
                        --recordSize;
                    } else {
                        threadId = buffer.getShort();
                        recordSize -= 2;
                    }
                    methodId = buffer.getInt();
                    recordSize -= 4;
                    switch (this.mClockSource) {
                        case WALL: {
                            threadTime = 0L;
                            globalTime = buffer.getInt();
                            recordSize -= 4;
                            break;
                        }
                        case DUAL: {
                            threadTime = buffer.getInt();
                            globalTime = buffer.getInt();
                            recordSize -= 8;
                            break;
                        }
                        default: {
                            threadTime = buffer.getInt();
                            globalTime = 0L;
                            recordSize -= 4;
                        }
                    }
                    while (recordSize-- > 0) {
                        buffer.get();
                    }
                }
                catch (BufferUnderflowException ex) {
                    break block41;
                }
                methodAction = methodId & 3;
                MethodData methodData = this.mMethodMap.get(methodId &= 0xFFFFFFFC);
                if (methodData == null) {
                    String name = String.format("(0x%1$x)", methodId);
                    methodData = new MethodData(methodId, name);
                    this.mMethodMap.put(methodId, methodData);
                }
                if ((threadData = this.mThreadMap.get(threadId)) == null) {
                    String name = String.format("[%1$d]", threadId);
                    threadData = new ThreadData(threadId, name, this.mTopLevel);
                    this.mThreadMap.put(Integer.valueOf(threadId), threadData);
                }
                long elapsedGlobalTime = 0L;
                if (haveGlobalClock) {
                    if (!threadData.mHaveGlobalTime) {
                        threadData.mGlobalStartTime = globalTime;
                        threadData.mHaveGlobalTime = true;
                    } else {
                        elapsedGlobalTime = globalTime - threadData.mGlobalEndTime;
                    }
                    threadData.mGlobalEndTime = globalTime;
                }
                if (haveThreadClock) {
                    long elapsedThreadTime = 0L;
                    if (!threadData.mHaveThreadTime) {
                        threadData.mThreadStartTime = threadTime;
                        threadData.mThreadCurrentTime = threadTime;
                        threadData.mHaveThreadTime = true;
                    } else {
                        elapsedThreadTime = threadTime - threadData.mThreadEndTime;
                    }
                    threadData.mThreadEndTime = threadTime;
                    if (!haveGlobalClock) {
                        if (prevThreadData != null && prevThreadData != threadData) {
                            Call switchCall = prevThreadData.enter(this.mContextSwitch, trace);
                            switchCall.mThreadStartTime = prevThreadData.mThreadEndTime;
                            this.mCallList.add(switchCall);
                            Call top = threadData.top();
                            if (top.getMethodData() == this.mContextSwitch) {
                                threadData.exit(this.mContextSwitch, trace);
                                long beforeSwitch = elapsedThreadTime / 2L;
                                top.mThreadStartTime += beforeSwitch;
                                top.mThreadEndTime = top.mThreadStartTime;
                            }
                        }
                        prevThreadData = threadData;
                    } else {
                        long sleepTime = elapsedGlobalTime - elapsedThreadTime;
                        if (sleepTime > 100L) {
                            Call switchCall = threadData.enter(this.mContextSwitch, trace);
                            long beforeSwitch = elapsedThreadTime / 2L;
                            long afterSwitch = elapsedThreadTime - beforeSwitch;
                            switchCall.mGlobalStartTime = globalTime - elapsedGlobalTime + beforeSwitch;
                            switchCall.mGlobalEndTime = globalTime - afterSwitch;
                            switchCall.mThreadEndTime = switchCall.mThreadStartTime = threadTime - afterSwitch;
                            threadData.exit(this.mContextSwitch, trace);
                            this.mCallList.add(switchCall);
                        }
                    }
                    Call top = threadData.top();
                    top.addCpuTime(elapsedThreadTime);
                }
                switch (methodAction) {
                    case 0: {
                        Call call = threadData.enter(methodData, trace);
                        if (haveGlobalClock) {
                            call.mGlobalStartTime = globalTime;
                        }
                        if (haveThreadClock) {
                            call.mThreadStartTime = threadTime;
                        }
                        this.mCallList.add(call);
                        continue block10;
                    }
                    case 1: 
                    case 2: {
                        Call call = threadData.exit(methodData, trace);
                        if (call == null) continue block10;
                        if (haveGlobalClock) {
                            call.mGlobalEndTime = globalTime;
                        }
                        if (!haveThreadClock) continue block10;
                        call.mThreadEndTime = threadTime;
                        continue block10;
                    }
                }
                break;
            }
            throw new RuntimeException("Unrecognized method action: " + methodAction);
        }
        for (ThreadData threadData : this.mThreadMap.values()) {
            threadData.endTrace(trace);
        }
        if (!haveGlobalClock) {
            long globalTime = 0L;
            prevThreadData = null;
            for (TraceAction traceAction : trace) {
                Call call = traceAction.mCall;
                ThreadData threadData = call.getThreadData();
                if (traceAction.mAction == 0) {
                    long threadTime = call.mThreadStartTime;
                    call.mGlobalStartTime = globalTime += call.mThreadStartTime - threadData.mThreadCurrentTime;
                    if (!threadData.mHaveGlobalTime) {
                        threadData.mHaveGlobalTime = true;
                        threadData.mGlobalStartTime = globalTime;
                    }
                    threadData.mThreadCurrentTime = threadTime;
                } else if (traceAction.mAction == 1) {
                    long threadTime = call.mThreadEndTime;
                    call.mGlobalEndTime = globalTime += call.mThreadEndTime - threadData.mThreadCurrentTime;
                    threadData.mGlobalEndTime = globalTime;
                    threadData.mThreadCurrentTime = threadTime;
                }
                prevThreadData = threadData;
            }
        }
        for (int i = this.mCallList.size() - 1; i >= 0; --i) {
            Call call = this.mCallList.get(i);
            long realTime = call.mGlobalEndTime - call.mGlobalStartTime;
            call.mExclusiveRealTime = Math.max(realTime - call.mInclusiveRealTime, 0L);
            call.mInclusiveRealTime = realTime;
            call.finish();
        }
        this.mTotalCpuTime = 0L;
        this.mTotalRealTime = 0L;
        for (ThreadData threadData : this.mThreadMap.values()) {
            Call rootCall = threadData.getRootCall();
            threadData.updateRootCallTimeBounds();
            rootCall.finish();
            this.mTotalCpuTime += rootCall.mInclusiveCpuTime;
            this.mTotalRealTime += rootCall.mInclusiveRealTime;
        }
        if (this.mRegression) {
            System.out.format("totalCpuTime %dus\n", this.mTotalCpuTime);
            System.out.format("totalRealTime %dus\n", this.mTotalRealTime);
            this.dumpThreadTimes();
            this.dumpCallTimes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long parseKeys() throws IOException {
        long offset = 0L;
        try (BufferedReader in = null;){
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.mTraceFileName), "US-ASCII"));
            int mode = 0;
            String line = null;
            while (true) {
                if ((line = in.readLine()) == null) {
                    throw new IOException("Key section does not have an *end marker");
                }
                offset += (long)(line.length() + 1);
                if (line.startsWith("*")) {
                    if (line.equals("*version")) {
                        mode = 0;
                        continue;
                    }
                    if (line.equals("*threads")) {
                        mode = 1;
                        continue;
                    }
                    if (line.equals("*methods")) {
                        mode = 2;
                        continue;
                    }
                    if (line.equals("*end")) {
                        break;
                    }
                }
                switch (mode) {
                    case 0: {
                        this.mVersionNumber = Integer.decode(line);
                        mode = 4;
                        break;
                    }
                    case 1: {
                        this.parseThread(line);
                        break;
                    }
                    case 2: {
                        this.parseMethod(line);
                        break;
                    }
                    case 4: {
                        this.parseOption(line);
                    }
                }
            }
        }
        if (this.mClockSource == null) {
            this.mClockSource = ClockSource.THREAD_CPU;
        }
        return offset;
    }

    void parseOption(String line) {
        String[] tokens = line.split("=");
        if (tokens.length == 2) {
            String key = tokens[0];
            String value = tokens[1];
            this.mPropertiesMap.put(key, value);
            if (key.equals("clock")) {
                if (value.equals("thread-cpu")) {
                    this.mClockSource = ClockSource.THREAD_CPU;
                } else if (value.equals("wall")) {
                    this.mClockSource = ClockSource.WALL;
                } else if (value.equals("dual")) {
                    this.mClockSource = ClockSource.DUAL;
                }
            }
        }
    }

    void parseThread(String line) {
        String idStr = null;
        String name = null;
        Matcher matcher = mIdNamePattern.matcher(line);
        if (matcher.find()) {
            idStr = matcher.group(1);
            name = matcher.group(2);
        }
        if (idStr == null) {
            return;
        }
        if (name == null) {
            name = "(unknown)";
        }
        int id = Integer.decode(idStr);
        this.mThreadMap.put(id, new ThreadData(id, name, this.mTopLevel));
    }

    void parseMethod(String line) {
        String[] tokens = line.split("\t");
        int id = Long.decode(tokens[0]).intValue();
        String className = tokens[1];
        String methodName = null;
        String signature = null;
        String pathname = null;
        int lineNumber = -1;
        if (tokens.length == 6) {
            methodName = tokens[2];
            signature = tokens[3];
            pathname = tokens[4];
            lineNumber = Integer.decode(tokens[5]);
            pathname = this.constructPathname(className, pathname);
        } else if (tokens.length > 2) {
            if (tokens[3].startsWith("(")) {
                methodName = tokens[2];
                signature = tokens[3];
            } else {
                pathname = tokens[2];
                lineNumber = Integer.decode(tokens[3]);
            }
        }
        this.mMethodMap.put(id, new MethodData(id, className, methodName, signature, pathname, lineNumber));
    }

    private String constructPathname(String className, String pathname) {
        int index = className.lastIndexOf(47);
        if (index > 0 && index < className.length() - 1 && pathname.endsWith(".java")) {
            pathname = className.substring(0, index + 1) + pathname;
        }
        return pathname;
    }

    private void analyzeData() {
        final TimeBase timeBase = this.getPreferredTimeBase();
        Collection<ThreadData> tv = this.mThreadMap.values();
        this.mSortedThreads = tv.toArray(new ThreadData[tv.size()]);
        Arrays.sort(this.mSortedThreads, new Comparator<ThreadData>(){

            @Override
            public int compare(ThreadData td1, ThreadData td2) {
                if (timeBase.getTime(td2) > timeBase.getTime(td1)) {
                    return 1;
                }
                if (timeBase.getTime(td2) < timeBase.getTime(td1)) {
                    return -1;
                }
                return td2.getName().compareTo(td1.getName());
            }
        });
        Collection<MethodData> mv = this.mMethodMap.values();
        MethodData[] methods = mv.toArray(new MethodData[mv.size()]);
        Arrays.sort(methods, new Comparator<MethodData>(){

            @Override
            public int compare(MethodData md1, MethodData md2) {
                if (timeBase.getElapsedInclusiveTime(md2) > timeBase.getElapsedInclusiveTime(md1)) {
                    return 1;
                }
                if (timeBase.getElapsedInclusiveTime(md2) < timeBase.getElapsedInclusiveTime(md1)) {
                    return -1;
                }
                return md1.getName().compareTo(md2.getName());
            }
        });
        int nonZero = 0;
        for (MethodData md : methods) {
            if (timeBase.getElapsedInclusiveTime(md) == 0L) break;
            ++nonZero;
        }
        this.mSortedMethods = new MethodData[nonZero];
        int ii = 0;
        for (MethodData md : methods) {
            if (timeBase.getElapsedInclusiveTime(md) == 0L) break;
            md.setRank(ii);
            this.mSortedMethods[ii++] = md;
        }
        for (MethodData md : this.mSortedMethods) {
            md.analyzeData(timeBase);
        }
        for (Call call : this.mCallList) {
            call.updateName();
        }
        if (this.mRegression) {
            this.dumpMethodStats();
        }
    }

    @Override
    public ArrayList<TimeLineView.Record> getThreadTimeRecords() {
        TimeLineView.Record record;
        ArrayList<TimeLineView.Record> timeRecs = new ArrayList<TimeLineView.Record>();
        for (ThreadData threadData : this.mSortedThreads) {
            if (threadData.isEmpty() || threadData.getId() == 0) continue;
            record = new TimeLineView.Record(threadData, threadData.getRootCall());
            timeRecs.add(record);
        }
        for (Call call : this.mCallList) {
            record = new TimeLineView.Record(call.getThreadData(), call);
            timeRecs.add(record);
        }
        if (this.mRegression) {
            this.dumpTimeRecs(timeRecs);
            System.exit(0);
        }
        return timeRecs;
    }

    private void dumpThreadTimes() {
        System.out.print("\nThread Times\n");
        System.out.print("id  t-start    t-end  g-start    g-end     name\n");
        for (ThreadData threadData : this.mThreadMap.values()) {
            System.out.format("%2d %8d %8d %8d %8d  %s\n", threadData.getId(), threadData.mThreadStartTime, threadData.mThreadEndTime, threadData.mGlobalStartTime, threadData.mGlobalEndTime, threadData.getName());
        }
    }

    private void dumpCallTimes() {
        System.out.print("\nCall Times\n");
        System.out.print("id  t-start    t-end  g-start    g-end    excl.    incl.  method\n");
        for (Call call : this.mCallList) {
            System.out.format("%2d %8d %8d %8d %8d %8d %8d  %s\n", call.getThreadId(), call.mThreadStartTime, call.mThreadEndTime, call.mGlobalStartTime, call.mGlobalEndTime, call.mExclusiveCpuTime, call.mInclusiveCpuTime, call.getMethodData().getName());
        }
    }

    private void dumpMethodStats() {
        System.out.print("\nMethod Stats\n");
        System.out.print("Excl Cpu  Incl Cpu  Excl Real Incl Real    Calls  Method\n");
        for (MethodData md : this.mSortedMethods) {
            System.out.format("%9d %9d %9d %9d %9s  %s\n", md.getElapsedExclusiveCpuTime(), md.getElapsedInclusiveCpuTime(), md.getElapsedExclusiveRealTime(), md.getElapsedInclusiveRealTime(), md.getCalls(), md.getProfileName());
        }
    }

    private void dumpTimeRecs(ArrayList<TimeLineView.Record> timeRecs) {
        System.out.print("\nTime Records\n");
        System.out.print("id  t-start    t-end  g-start    g-end  method\n");
        for (TimeLineView.Record record : timeRecs) {
            Call call = (Call)record.block;
            System.out.format("%2d %8d %8d %8d %8d  %s\n", call.getThreadId(), call.mThreadStartTime, call.mThreadEndTime, call.mGlobalStartTime, call.mGlobalEndTime, call.getMethodData().getName());
        }
    }

    @Override
    public HashMap<Integer, String> getThreadLabels() {
        HashMap<Integer, String> labels = new HashMap<Integer, String>();
        for (ThreadData t : this.mThreadMap.values()) {
            labels.put(t.getId(), t.getName());
        }
        return labels;
    }

    @Override
    public MethodData[] getMethods() {
        return this.mSortedMethods;
    }

    @Override
    public ThreadData[] getThreads() {
        return this.mSortedThreads;
    }

    @Override
    public long getTotalCpuTime() {
        return this.mTotalCpuTime;
    }

    @Override
    public long getTotalRealTime() {
        return this.mTotalRealTime;
    }

    @Override
    public boolean haveCpuTime() {
        return this.mClockSource != ClockSource.WALL;
    }

    @Override
    public boolean haveRealTime() {
        return this.mClockSource != ClockSource.THREAD_CPU;
    }

    @Override
    public HashMap<String, String> getProperties() {
        return this.mPropertiesMap;
    }

    @Override
    public TimeBase getPreferredTimeBase() {
        if (this.mClockSource == ClockSource.WALL) {
            return TimeBase.REAL_TIME;
        }
        return TimeBase.CPU_TIME;
    }

    @Override
    public String getClockSource() {
        switch (this.mClockSource) {
            case THREAD_CPU: {
                return "cpu time";
            }
            case WALL: {
                return "real time";
            }
            case DUAL: {
                return "real time, dual clock";
            }
        }
        return null;
    }

    private static enum ClockSource {
        THREAD_CPU,
        WALL,
        DUAL;

    }
}

