/**
 * Provides classes and interfaces for key specifications and algorithm
 * parameter specifications.
 *
 * <p>A key specification is a transparent representation of the key
 * material that constitutes a key. A key may be specified in an
 * algorithm-specific way, or in an algorithm-independent encoding format
 * (such as ASN.1).  This package contains key specifications for
 * Diffie-Hellman public and private keys, as well as key specifications for DES,
 * Triple DES, and PBE secret keys.
 *
 * <p>An algorithm parameter specification is a transparent representation
 * of the sets of parameters used with an algorithm. This package contains
 * algorithm parameter specifications for parameters used with the
 * Diffie-Hellman, DES, Triple DES, PBE, RC2 and RC5 algorithms.
 *
 * <h2>Package Specification</h2>
 *
 * <ul>
 *   <li>PKCS #3: Diffie-Hellman Key-Agreement Standard, Version 1.4,
 *   November 1993.</li>
 *   <li>PKCS #5: Password-Based Encryption Standard, Version 1.5,
 *   November 1993.</li>
 *   <li>Federal Information Processing Standards Publication (FIPS PUB) 46-2:
 *   Data Encryption Standard (DES) </li>
 * </ul>
 *
 * <h2>Related Documentation</h2>
 *
 * For documentation that includes information about algorithm parameter
 * and key specifications, please see:
 * <ul>
 *   <li>
 *     <a href=
 *       "{@docRoot}/../technotes/guides/security/crypto/CryptoSpec.html">
 *       <b>Java<FONT SIZE=-2><SUP>TM</SUP></FONT>
 *       Cryptography Architecture API Specification and Reference
 *       </b></a></li>
 *   <li>
 *     <a href=
 *       "{@docRoot}/../technotes/guides/security/crypto/HowToImplAProvider.html">
 *       <b>How to Implement a Provider for the
 *       Java<FONT SIZE=-2><SUP>TM</SUP></FONT> Cryptography Architecture
 *       </b></a></li>
 * </ul>
 *
 * @since 1.4
 */

package javax.crypto.spec;
