/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.util.function;


/**
 * Represents an operation on a single {@code int}-valued operand that produces
 * an {@code int}-valued result.  This is the primitive type specialization of
 * {@link java.util.function.UnaryOperator UnaryOperator} for {@code int}.
 *
 * <p>This is a <a href="package-summary.html">functional interface</a>
 * whose functional method is {@link #applyAsInt(int)}.
 *
 * @see java.util.function.UnaryOperator
 * @since 1.8
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
@java.lang.FunctionalInterface
public interface IntUnaryOperator {

/**
 * Returns a composed operator that first applies this operator to
 * its input, and then applies the {@code after} operator to the result.
 * If evaluation of either operator throws an exception, it is relayed to
 * the caller of the composed operator.
 *
 * @param after the operator to apply after this operator is applied
 * @return a composed operator that first applies this operator and then
 * applies the {@code after} operator
 * @throws java.lang.NullPointerException if after is null
 *
 * @see #compose(IntUnaryOperator)
 */

public default java.util.function.IntUnaryOperator andThen(java.util.function.IntUnaryOperator after) { throw new RuntimeException("Stub!"); }

/**
 * Applies this operator to the given operand.
 *
 * @param operand the operand
 * @return the operator result
 */

public int applyAsInt(int operand);

/**
 * Returns a composed operator that first applies the {@code before}
 * operator to its input, and then applies this operator to the result.
 * If evaluation of either operator throws an exception, it is relayed to
 * the caller of the composed operator.
 *
 * @param before the operator to apply before this operator is applied
 * @return a composed operator that first applies the {@code before}
 * operator and then applies this operator
 * @throws java.lang.NullPointerException if before is null
 *
 * @see #andThen(IntUnaryOperator)
 */

public default java.util.function.IntUnaryOperator compose(java.util.function.IntUnaryOperator before) { throw new RuntimeException("Stub!"); }

/**
 * Returns a unary operator that always returns its input argument.
 *
 * @return a unary operator that always returns its input argument
 */

public static java.util.function.IntUnaryOperator identity() { throw new RuntimeException("Stub!"); }
}

